
/**
 * wathello.java
 *
 *
 * Created: Tue May 11 23:02:17 1999
 *
 * @author TAKEchi Masashi
 * @version
 */

import waba.ui.*;
import waba.fx.*;
import waba.io.*;
import waba.sys.*;

/**
 * A control that displays an application's title.
 * taken from Scribble example.
 */
class Title extends Control
{
    String name;
    Font font;
    
    public Title(String name){
	this.name=name;
	this.font=new Font("Helvetica", Font.BOLD, 12);
    }
    
    public void onPaint(Graphics g){
	// draw line across
	g.setColor(0, 0, 0);
	int y = this.height - 1;
	g.drawLine(0, y, this.width, y);
	y--;
	g.drawLine(0, y, this.width, y);
	
	// draw title
	FontMetrics fm = getFontMetrics(font);
	int boxWidth = fm.getTextWidth(name) + 8;
	g.fillRect(0, 0, boxWidth, y);
	g.setColor(255, 255, 255);
	g.setFont(font);
	g.drawText(name, 4, 2);
    }
}
// Cell class
class Cell{
    static final byte NONE=0;
    static final byte WHITE=1;
    static final byte BLACK=2;
    int x, y, a; // position (x, y), size a
    byte att; // NONE, WHITE or BLACK
    int point;

    public Cell(int x,int y,int a){
	this.att=NONE;
	this.x=x;
	this.y=y;
	this.a=a;
    }
    // set Cell attribute
    public void set(byte att){
	this.att=att;
    }
    // reverse dot
    public void reverse(){
	if(this.att==WHITE){
	    this.att=BLACK;
	}
	else if(this.att==BLACK){
	    this.att=WHITE;
	}
    }
    public byte check(){
	return this.att;
    }
    public boolean contains(int x,int y){
	if (x<this.x || x>=this.x+a || y<this.y || y>this.y+a){
	    return false;
	}
	return true;
    }
    public void paint(Graphics g){
	//g.setColor(0,0,0); // black
	//g.fillRect(x,y,a,a);
	g.setColor(255,255,255); // white
	g.fillRect(x+1,y+1,a-2,a-2);
	if(this.att!=NONE){
	    g.setColor(0,0,0); // black
	    g.fillRect(x+2,y+2,a-4,a-4);
	}
	if(this.att==WHITE){
	    g.setColor(255,255,255); // white
	    g.fillRect(x+3,y+3,a-6,a-6);
	}
    }
}
// Random class
class Random{
  byte xn,a,b,c;
    public Random(){ // Default constructor uses time as start number
	Time t=new Time();
	a=3;
	b=7;
	c=127;
	xn=(byte)(t.second%c);
    }
    // generate random number
    public byte getRandom(byte n){
	xn=(byte)(((xn*a)+b)%c);
	return (byte)(xn%n);
    }		 
} // Random

class Board{
    static final byte OUT=-1;
    static final byte NONE=0;
    static final byte ENEMY=-2;
    static final byte WHITE=1;
    static final byte BLACK=2;
    static final byte XMAX=8;
    static final byte YMAX=8;
    static final byte CELLSIZE=14;
    static final byte XOFFSET=3;
    static final byte YOFFSET=15;
    Cell[][] Cells=new Cell[XMAX][YMAX];
    int Eva;
    byte Black,White;

    public Board(){
	clear();
    }
    public void clear(){
	for(byte x=0;x<XMAX;x++){
	    for(byte y=0;y<YMAX;y++){
		Cells[x][y]=new Cell(x*CELLSIZE+XOFFSET,y*CELLSIZE+YOFFSET
				     ,CELLSIZE);
	    }
	}
	Cells[3][3].set(Cell.WHITE);
	Cells[4][4].set(Cell.WHITE);
	Cells[3][4].set(Cell.BLACK);
	Cells[4][3].set(Cell.BLACK);
    }
    public void paint(Graphics g){
	g.setColor(0,0,0); // black
	for(byte x=0;x<=XMAX;x++){
	    g.drawLine(x*CELLSIZE+XOFFSET,YOFFSET
		       ,x*CELLSIZE+XOFFSET,YMAX*CELLSIZE+YOFFSET);
	}
	for(byte y=0;y<=YMAX;y++){
	    g.drawLine(XOFFSET,y*CELLSIZE+YOFFSET
		       ,XMAX*CELLSIZE+XOFFSET,y*CELLSIZE+YOFFSET);
	}
	for(char x=0;x<XMAX;x++){
	    for(char y=0;y<YMAX;y++){
		Cells[x][y].paint(g);
	    }
	}
    }
    private byte edge_check(byte x, byte y,int dx,int dy,byte color){
	return edge_check(x,y,(byte)dx,(byte)dy,color);
    }
    /** check edge */
    // return OUT,NONE,ENEMY
    private byte edge_check(byte x, byte y,byte dx,byte dy,byte color){
	byte i,j;
	for(i=(byte)(x+dx),j=(byte)(y+dy)
		;i>=0 && i<XMAX && j>=0 && j<YMAX;i+=dx,j+=dy){
	    if(Cells[i][j].check()==Cell.NONE){
		return NONE;
	    }
	    else if(Cells[i][j].check()!=color){
		return ENEMY;
	    }
	}
	return OUT;
    }
    /** calc line eva */
    private int lineEva(byte e1,byte e2,byte color){
	int fugou;
	int ret=1; // return status
	if(color==BLACK){
	    fugou=1;
	}
	else{
	    fugou=-1;
	}
	/*
	     O  N  E
	  O  4  3  2
	  N     0 -1
	  E        1
	 */
	switch(e1){
	case OUT:
	    switch(e2){
	    case OUT:
		ret=fugou*4;
	    case NONE:
		ret=fugou*3;
	    case ENEMY:
		ret=fugou*2;
	    }
	case NONE:
	    switch(e2){
	    case OUT:
		ret=fugou*3;
	    case NONE:
		ret=fugou*0;
	    case ENEMY:
		ret=fugou*(-1);
	    }
	case ENEMY:
	    switch(e2){
	    case OUT:
		ret=fugou*2;
	    case NONE:
		ret=fugou*(-1);
	    case ENEMY:
		ret=fugou*1;
	    }
	}
	return ret;
    }
    /** caluclate status */
    public void calc_status(){
	byte att;
	byte e1,e2;
	Eva=0;
	Black=White=0;
	for(byte x=0;x<XMAX;x++){
	    for(byte y=0;y<YMAX;y++){
		if((att=Cells[x][y].check())==Cell.NONE){
		    continue;
		}
		else if(att==Cell.BLACK){
		    Black++;
		}
		else{
		    White++;
		}
		e1=edge_check(x,y,-1,0,att); // left
		e2=edge_check(x,y,1,0,att); // right
		Eva+=lineEva(e1,e2,att);
		e1=edge_check(x,y,0,-1,att); // up
		e2=edge_check(x,y,0,1,att); // down
		Eva+=lineEva(e1,e2,att);
		e1=edge_check(x,y,-1,-1,att); // left up
		e2=edge_check(x,y,1,1,att); // right down
		Eva+=lineEva(e1,e2,att);
		e1=edge_check(x,y,-1,1,att); // left down
		e2=edge_check(x,y,1,-1,att); // right up
		Eva+=lineEva(e1,e2,att);
	    }
	}
    }

    /** reverse */
    private void reverse(byte x,byte y,int dx,int dy,byte color){
	reverse(x,y,(byte)dx,(byte)dy,color);
    }
    private void reverse(byte x,byte y,byte dx,byte dy,byte color){
	byte i,j;
	byte enecolor;
	if(color==Cell.WHITE){
	    enecolor=Cell.BLACK;
	}
	else{
	    enecolor=Cell.WHITE;
	}
	for(i=(byte)(x+dx),j=(byte)(y+dy);;i+=dx,j+=dy){
	    if(Cells[i][j].check()==color){
		return;
	    }
	    Cells[i][j].set(color);
	}
    }

    //
    private boolean checkput(byte x,byte y,int dx,int dy,byte color){
	return checkput(x,y,(byte)dx,(byte)dy,color);
    }
    private boolean checkput(byte x,byte y,byte dx,byte dy,byte color){
	byte i,j;
	byte chkcol;
	i=(byte)(x+dx);
	j=(byte)(y+dy);
	if(i<0 || i>=XMAX || j<0 || j>=YMAX){
	    return false;
	}
	if(Cells[i][j].check()==Cell.NONE
	   || Cells[i][j].check()==color){
	    return false;
	}
	i+=dx;
	j+=dy;
	for(;i>=0 && i<XMAX && j>=0 && j<YMAX;i+=dx,j+=dy){
	    if((chkcol=Cells[i][j].check())==Cell.NONE){
		return false;
	    }
	    else if(chkcol==color){
		return true;
	    }
	}
	return false;
    }
    public boolean canput(byte x,byte y,byte color){
	if(Cells[x][y].check()!=Cell.NONE){
	    return false;
	}
	if(checkput(x,y,1,0,color)){ // right
	    return true;
	}
	if(checkput(x,y,-1,0,color)){ // left
	    return true;
	}
	if(checkput(x,y,0,1,color)){ //down
	    return true;
	}
	if(checkput(x,y,0,-1,color)){ // up
	    return true;
	}
	if(checkput(x,y,1,1,color)){ // right down
	    return true;
	}
	if(checkput(x,y,1,-1,color)){ // right up
	    return true;
	}
	if(checkput(x,y,-1,1,color)){ //left down
	    return true;
	}
	if(checkput(x,y,-1,-1,color)){ //left up
	    return true;
	}
	return false;
    }
    /** Set and Reverse */
    public boolean set(byte x,byte y,byte color){
	boolean ret;
	if(Cells[x][y].check()!=Cell.NONE){
	    return false;
	}
	ret=false;
	if(checkput(x,y,1,0,color)){ // right
	    reverse(x,y,1,0,color);
	    ret=true;
	}
	if(checkput(x,y,-1,0,color)){ // left
	    reverse(x,y,-1,0,color);
	    ret=true;
	}
	if(checkput(x,y,0,1,color)){ //down
	    reverse(x,y,0,1,color);
	    ret=true;
	}
	if(checkput(x,y,0,-1,color)){ // up
	    reverse(x,y,0,-1,color);
	    ret=true;
	}
	if(checkput(x,y,1,1,color)){ // right down
	    reverse(x,y,1,1,color);
	    ret=true;
	}
	if(checkput(x,y,1,-1,color)){ // right up
	    reverse(x,y,1,-1,color);
	    ret=true;
	}
	if(checkput(x,y,-1,1,color)){ //left down
	    reverse(x,y,-1,1,color);
	    ret=true;
	}
	if(checkput(x,y,-1,-1,color)){ //left up
	    reverse(x,y,-1,-1,color);
	    ret=true;
	}
	if(ret){
	    Cells[x][y].set(color);
	}
	return ret;
    }
    // pos (x,y) put color
    public boolean put(int x,int y,byte color){
	return put((byte)x,(byte)y,color);
    }
    public boolean put(byte x,byte y,byte color){
	for(byte i=0;i<XMAX;i++){
	    for(byte j=0;j<YMAX;j++){
		if(Cells[i][j].contains(x,y)){
		    //Sound.beep();
		    if(set(i,j,color)){
			return true;
		    }
		    else{
			return false;
		    }
		}
	    }
	}
	return false;
    }
    /** pass? */
    public boolean isPass(byte color){
	for(byte i=0;i<XMAX;i++){
	    for(byte j=0;j<YMAX;j++){
		if(canput(i,j,color)){
		    return false;
		}
	    }
	}
	return true;
    }
    /** copy Board class */
    public void copyBoard(Board src){
	for(byte i=0;i<XMAX;i++){
	    for(byte j=0;j<YMAX;j++){
		this.Cells[i][j].set(src.Cells[i][j].check());
	    }
	}
    }
}

// Game class
class Game extends Control{
    static final byte WHITE=1;
    static final byte BLACK=2;
    static final String CATALOGNAME=new String("GqIE.DATA");
    static private Graphics graphics;
    static byte[] Jun={0,7,2,5,4,3,1,6};
    private byte Turn;
    public boolean[] isCom=new boolean[2];
    public Board PlayBoard;

    public Game(){
	PlayBoard=new Board();
	Turn=BLACK;
	manIs(BLACK);
	manIs(WHITE);
	clear();
	// loadState();
    }
    public void added(){
	graphics=createGraphics();
    }
    public boolean isCom(byte color){
	return isCom[color-1];
    }
    public void comIs(byte color){
	isCom[color-1]=true;
    }
    public void manIs(byte color){
	isCom[color-1]=false;
    }
    public void clear(){    
	Sound.beep();
	PlayBoard.clear();
    }
    public void onPaint(Graphics g){
	PlayBoard.paint(g);
	showStatus();
    }

    public void onEvent(Event event){
	if(event.type==PenEvent.PEN_DOWN && !isCom(Turn)){
	    PenEvent pe=(PenEvent)event;
	    if(PlayBoard.put(pe.x,pe.y,Turn)){
		Turn=(byte)((Turn%2)+1);
		if(PlayBoard.isPass(Turn)){
		    Turn=(byte)((Turn%2)+1);
		}
		onPaint(graphics);
	    }
	    else{
		Sound.beep();
	    }
	}
    }

    /** search Max evaluate position */
    private void searchMaxPos(Board orgBoard,byte color,byte[] x,byte[] y){
	byte setcnt=0;
	int point;
	int maxpoint=-10000;
	int secpoint=-10000;
	int fugo;
	Board comBoard=new Board();
	if(color==Cell.WHITE){
	    fugo=-1;
	}
	else{
	    fugo=1;
	}
	for(byte i=0;i<Board.XMAX;i++){
	    for(byte j=0;j<Board.YMAX;j++){
		comBoard.copyBoard(orgBoard);
		if(comBoard.set(Jun[i],Jun[j],color)){
		    comBoard.calc_status();
		    if((point=comBoard.Eva*fugo)>maxpoint){
			secpoint=maxpoint;
			maxpoint=point;
			x[1]=x[0];
			y[1]=y[0];
			x[0]=Jun[i];
			y[0]=Jun[j];
		    }
		    else if(point>secpoint){
			secpoint=point;
			x[1]=Jun[i];
			y[1]=Jun[j];
		    }
		    setcnt++;
		    if(setcnt>2){ //////////////////////////
			return;
		    }
		}
	    }
	}
    }
    /** Com thinking algorithm */
    private boolean thinkCom(byte color){
	byte[] x=new byte[2];
	byte[] y=new byte[2];
	byte[] x2=new byte[2];
	byte[] y2=new byte[2];
	int[] eva2=new int[2];
	byte enemy;
	int fugo;
	Board secBoard=new Board();

	if(color==Cell.WHITE){
	    fugo=-1;
	    enemy=Cell.BLACK;
	}
	else{
	    fugo=1;
	    enemy=Cell.WHITE;
	}
	/*
	int eva;
	int maxpoint=-10000;
	byte maxx=0,maxy=0;
	for(byte i=0;i<Board.XMAX;i++){
	    for(byte j=0;j<Board.YMAX;j++){
		secBoard.copyBoard(PlayBoard);
		if(!secBoard.set(i,j,color)){
		    continue;
		}
		searchMaxPos(secBoard,enemy,x2,y2);
		secBoard.set(x2[0],y2[0],enemy);
		secBoard.calc_status();
		if((eva=secBoard.Eva*fugo)>maxpoint){
		    maxpoint=eva;
		    maxx=i;
		    maxy=j;
		}
	    }
	}
	if(PlayBoard.set(maxx,maxy,color)){
	    return true;
	}
	*/
	searchMaxPos(PlayBoard,color,x,y); // first search
	for(int i=0;i<2;i++){ // second search
	    secBoard.copyBoard(PlayBoard);
	    secBoard.set(x[i],y[i],color);
	    searchMaxPos(secBoard,enemy,x2,y2);
	    secBoard.set(x2[0],y2[0],enemy);
	    secBoard.calc_status();
	    eva2[i]=secBoard.Eva*fugo;
	}
	if(eva2[0]>eva2[1]){
	    PlayBoard.set(x[0],y[0],color);
	}
	else{
	    PlayBoard.set(x[1],y[1],color);
	}
	return true;
    }
    /** Computer put */
    public boolean comput(){
	byte color=Turn;
	if(!isCom(color)){
	    return false;
	}
	thinkCom(color);
	Turn=(byte)((Turn%2)+1);
	if(PlayBoard.isPass(Turn)){
	    Turn=(byte)((Turn%2)+1);
	}
	onPaint(graphics);
	return true;
    }

    /** show current status */
    public void showStatus(){
	graphics.setColor(255,255,255);
	graphics.fillRect(0,0,width,14);
	graphics.setColor(0,0,0);
	String who;
	String num;
	String e;

	PlayBoard.calc_status(); // calc Eva,Black and White.
	num=new String(" B="+PlayBoard.Black+" W="+PlayBoard.White);
	if(PlayBoard.Black+PlayBoard.White==64){ // Game End.
	    if(PlayBoard.Black>PlayBoard.White){
		graphics.drawText("Black Win!"+num, 3, 2);
	    }
	    else if(PlayBoard.Black<PlayBoard.White){
		graphics.drawText("White Win!"+num, 3, 2);
	    }
	    else{
		graphics.drawText("Draw Game."+num, 3, 2);
	    }
	}
	else{
	    if(isCom(Turn)){
		who=new String("(Com)");
	    }
	    else{
		who=new String("(Man)");
	    }
	    e=new String(" ("+PlayBoard.Eva+")");
	    if(Turn==BLACK){
		graphics.drawText("Turn: Black "+who+num+e, 3, 2);
	    }
	    else{
	    graphics.drawText("Turn: White "+who+num+e, 3, 2);
	    }
	}
    }
    public void resetGame(){
	Sound.beep();
	PlayBoard.clear();
	Turn=this.BLACK;
    }
    public void saveState(){
    }
}

/*
 * Wathello Main class.
 */
public class wathello extends MainWindow {
    static final int PLAY=0;
    static final int ABOUT=1;
    
    private Game board;
    private Button closeButton;
    private Button resetButton;
    private Radio manman;
    private Radio mancom;
    private Radio comman;
    private Radio comcom;
    Timer timer;
    
    int state=PLAY;
    
    public wathello() {
	Title title=new Title("Wathello");
	title.setRect(0,0,this.width,15);
	add(title);
	
	closeButton=new Button("Close");
	closeButton.setRect(0,this.height-15,44,15);
	add(closeButton);
	
	resetButton=new Button("Reset");
	resetButton.setRect(46,this.height-15,44,15);
	add(resetButton);

	manman = new Radio("M-M");
	manman.setRect(118, 30, 30, 15);
	add(manman);
	manman.setChecked(true);

	mancom = new Radio("M-C");
	mancom.setRect(118, 47, 30, 15);
	add(mancom);

	comman = new Radio("C-M");
	comman.setRect(118, 64, 30, 15);
	add(comman);

	comcom = new Radio("C-C");
	comcom.setRect(118, 81, 30, 15);
	add(comcom);

       	board=new Game();
	board.setRect(0,15,this.width,this.height-40);
	add(board);
	board.added();
	if (timer == null){
	    // update every second
	    timer=addTimer(1000);
	}
    }
    public void onExit(){
	board.saveState();
    }

    public void onEvent(Event event){
	if (event.type==ControlEvent.PRESSED){
	    if(event.target==closeButton){
		exit(0);
	    }
	    else if(event.target==resetButton){
		board.resetGame();
		this.repaint();
	    }
	    else if(event.target==manman){
		mancom.setChecked(false);
		comman.setChecked(false);
		comcom.setChecked(false);
		board.manIs(board.BLACK);
		board.manIs(board.WHITE);
	    }
	    else if(event.target==mancom){
		manman.setChecked(false);
		comman.setChecked(false);
		comcom.setChecked(false);
		board.manIs(board.BLACK);
		board.comIs(board.WHITE);
	    }
	    else if(event.target==comman){
		manman.setChecked(false);
		mancom.setChecked(false);
		comcom.setChecked(false);
		board.comIs(board.BLACK);
		board.manIs(board.WHITE);
	    }
	    else if(event.target==comcom){
		manman.setChecked(false);
		mancom.setChecked(false);
		comman.setChecked(false);
		board.comIs(board.BLACK);
		board.comIs(board.WHITE);
	    }
	}
	else if(event instanceof KeyEvent){
	    KeyEvent e=(KeyEvent)event;
	    if (e.key==IKeys.MENU || e.key=='i'){
		drawAbout(new Graphics(this),state!=ABOUT);
	    }
	}
	else if(event instanceof PenEvent){
	    PenEvent e=(PenEvent)event;
	    switch(e.type){
	    case PenEvent.PEN_DOWN:
		if(state==ABOUT){
		    drawAbout(new Graphics(this),false);
		    return;
		}
	    }
	    board.onEvent(event);
	}
	else if(event.type==ControlEvent.TIMER && state!=ABOUT){
	    board.comput();
	}
    }

    public void drawRect(Graphics g,int x,int y,int w,int h){
	g.setColor(255,255,255);
	g.fillRect(x,y,w,h);
	g.setColor(0,0,0);
	w--;
	h--;
	g.drawLine(x,y,x+w,y);
	g.drawLine(x+w,y,x+w,y+h);
	g.drawLine(x,y,x,y+h);
	g.drawLine(x,y+h,x+w,y+h);
    }

    public void drawCenteredText(Graphics g,String s,int x,int y){
	FontMetrics fm=getFontMetrics(defaultFont);
	g.drawText(s,x-fm.getTextWidth(s)/2,y-fm.getAscent()/2);
    }

    public void drawAbout(Graphics g,boolean b){
	int w=width;
	int h=height/2;
	if(b){
	    Sound.beep();
	    Sound.tone(2000,200);
	    Sound.tone(4000,200);
	    g.translate(0,height/4);
	    state=ABOUT;
	    drawRect(g,0,0,w,h);
	    drawCenteredText(g,"Wathello v.0.0",w/2,h/5);
	    drawCenteredText(g,"by TAKEchi Masashi",w/2,2*h/5);
	    drawCenteredText(g,"take@TAKEchon.NET",w/2,3*h/5);
	    drawCenteredText(g,"http://www.TAKEchon.NET/",w/2,4*h/5);
	    g.translate(0,-height/4);
	}
	else{
	    state=PLAY;
	    damageRect(0,height/4,w,h);
	}                                           
    }
} // wathello

