/*
 * DataFieldForm.java
 * $Id: DateFieldForm.java,v 1.2 2003/03/02 07:31:31 take Exp $
 * 
 * Copyright Studio High-Score All Rights Reserved.
 *
 */
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.util.Calendar;

/**
 * DataFieldForm
 * t̓̓tH[
 *
 * @author TAKEchi Masashi
 * @version
 */
final class DateFieldForm extends Form
    implements CommandListener {

    private DateField dateField;
    private MIDlet midlet;
    private GasGuzzlerCanvas GgCanvas;

    public DateFieldForm(MIDlet midlet
                         , GasGuzzlerCanvas ggc
                         ) {
        super("Date");

        this.midlet = midlet;
        this.GgCanvas = ggc;

        dateField = new DateField("DATE", DateField.DATE);
        append(dateField);

        addCommand(new Command("set", Command.SCREEN, 0));
        setCommandListener(this);
    }
    //R}hCxg
    public synchronized void commandAction(Command c, Displayable s) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateField.getDate());

        GgCanvas.Year = cal.get(Calendar.YEAR);
        GgCanvas.Month = cal.get(Calendar.MONTH) + 1;
        GgCanvas.Day = cal.get(Calendar.DATE);

        (Display.getDisplay(midlet)).setCurrent(GgCanvas);
    }
}
