/*
 * GasGuzzlerCanvas.java
 * $Id: GasGuzzlerCanvas.java,v 1.7 2003/03/02 07:31:31 take Exp $
 * 
 * Copyright Studio High-Score All Rights Reserved.
 *
 */
import java.util.Calendar;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.rms.*;
import java.io.*;
import javax.microedition.io.*;

import com.kddi.system.*;

/**
 * GasGuzzlerCanvas
 * CLoX
 *
 * @author TAKEchi Masashi
 * @version
 */
final class GasGuzzlerCanvas extends Canvas
    implements Runnable,CommandListener {

    private final int BACKCOLOR = (57<<16) + (221<<8) + 156;

    private final String  setUrl = "http://www.takechon.net/servlet/net.takechon.take.GasGuzzler.GasGuzzlerServlet";

    // ̓tF[Y
    private final static int S_DISTANCE1 = 0; // 
    private final static int S_DISTANCE2 = 1; // 
    private final static int S_LITER1 = 2; // b^[
    private final static int S_LITER2 = 3; // b^[
    private final static int S_PAY = 4; // x
    private final static int S_SENDED = 5; // M

    private final static int ADVANCE_Y = 15; // Y 
    private final static int ADVANCE_Y2 = 20; // Y 
    
    private int scene = S_DISTANCE1; // ̓̓tF[Y
    private StringBuffer Dist1; // 
    private StringBuffer Dist2; // 
    private StringBuffer Liter1; // b^[
    private StringBuffer Liter2; // b^[
    private StringBuffer Pay; // x
    
    private String Ido = "0";
    private String Keido = "0";

    public int Year;
    public int Month;
    public int Day;

    public String Username = "guest"; // [U
    public String Password = "guest"; // pX[h

    private String msg = ""; // bZ[W

    //Command clearCommand; // NAR}h
    Command sendCommand; // MR}h
    Command configCommand; // ݒR}h
    Command helpCommand; // wvR}h
    Command gpsCommand; // GPS R}h
    Command dateCommand; // GPS R}h
    Command debugCommand; // MR}h (GPS őM)

    //_uobt@O
    private Image imgOff;//ItC[W
    private Graphics graOff;//ItOtBNX

    private MIDlet midlet;
    
    // Constructor
    public GasGuzzlerCanvas(MIDlet midlet) {
        this.midlet = midlet;

        Dist1 = new StringBuffer(); // 
        Dist2 = new StringBuffer(); // 
        Liter1 = new StringBuffer(); // b^[
        Liter2 = new StringBuffer(); // b^[
        Pay = new StringBuffer(); // x
        Dist1.append(0);
        Dist2.append(0);
        Liter1.append(0);
        Liter2.append(0);
        Pay.append(0);

        Calendar today = Calendar.getInstance();
        Year = today.get(Calendar.YEAR);
        Month = today.get(Calendar.MONTH) + 1;
        Day = today.get(Calendar.DATE);

        // ItC[W̐
        imgOff=Image.createImage(getWidth(),getHeight());
        graOff=imgOff.getGraphics();
        
        // {^̐
        //clearCommand = new Command("CLEAR", Command.SCREEN, 0);
        sendCommand = new Command("SEND", Command.SCREEN, 1);
        dateCommand = new Command("DATE", Command.SCREEN, 2);
        configCommand = new Command("CONF", Command.SCREEN, 3);
        gpsCommand = new Command("GPS", Command.SCREEN, 4);
        helpCommand = new Command("HELP", Command.SCREEN, 5);
        debugCommand = new Command("debug", Command.SCREEN, 6);
        //addCommand(clearCommand);
        addCommand(sendCommand);
        addCommand(dateCommand);
        addCommand(configCommand);
        addCommand(gpsCommand);
        addCommand(helpCommand);
        addCommand(debugCommand);
        setCommandListener(this);

        loadConfigData(); // [UƃpX[h̓ǂݍ
        loadCurrentData(); // ̓f[^̓ǂݍ
    }

    public void saveConfigData() {
        try {
            RecordStore rs = RecordStore.openRecordStore("GasGuzzler", true);
            byte[] ubyte = Username.getBytes();
            byte[] pbyte = Password.getBytes();
            if(rs.getNumRecords() == 0) {
                rs.addRecord(ubyte, 0, ubyte.length);
                rs.addRecord(pbyte, 0, pbyte.length);
            }
            else {
                rs.setRecord(1, ubyte, 0, ubyte.length);
                rs.setRecord(2, pbyte, 0, pbyte.length);
            }
            rs.closeRecordStore();
        } catch(Exception e) {
        }
    }
    private void loadConfigData() {
        try {
            RecordStore rs = RecordStore.openRecordStore("GasGuzzler", false);
            Username = new String(rs.getRecord(1));
            Password = new String(rs.getRecord(2));
            rs.closeRecordStore();
        } catch(Exception e) {
        }
    }
    
    public void saveCurrentData() {

        try {
            RecordStore rs = RecordStore.openRecordStore("CurData", true);
            byte[] d1byte = Dist1.toString().getBytes();
            byte[] d2byte = Dist2.toString().getBytes();
            byte[] l1byte = Liter1.toString().getBytes();
            byte[] l2byte = Liter2.toString().getBytes();
            byte[] pbyte = Pay.toString().getBytes();
            byte[] mbyte = msg.getBytes();
            
            if(rs.getNumRecords() == 0) {
                rs.addRecord(d1byte, 0, d1byte.length);
                rs.addRecord(d2byte, 0, d2byte.length);
                rs.addRecord(l1byte, 0, l1byte.length);
                rs.addRecord(l2byte, 0, l2byte.length);
                rs.addRecord(pbyte, 0, pbyte.length);
                rs.addRecord(mbyte, 0, mbyte.length);
            }
            else {
                rs.setRecord(1, d1byte, 0, d1byte.length);
                rs.setRecord(2, d2byte, 0, d2byte.length);
                rs.setRecord(3, l1byte, 0, l1byte.length);
                rs.setRecord(4, l2byte, 0, l2byte.length);
                rs.setRecord(5, pbyte, 0, pbyte.length);
                rs.setRecord(6, mbyte, 0, mbyte.length);
            }
            rs.closeRecordStore();
        } catch(Exception e) {
        }
    }
    private void loadCurrentData() {
        try {
            RecordStore rs = RecordStore.openRecordStore("CurData", false);
            Dist1.delete(0, Dist1.length());
            Dist1.append(new String(rs.getRecord(1)));
            Dist2.delete(0, Dist2.length());
            Dist2.append(new String(rs.getRecord(2)));
            Liter1.delete(0, Liter1.length());
            Liter1.append(new String(rs.getRecord(3)));
            Liter2.delete(0, Liter2.length());
            Liter2.append(new String(rs.getRecord(4)));
            Pay.delete(0, Pay.length());
            Pay.append(new String(rs.getRecord(5)));
            msg = new String(rs.getRecord(6));
            
            rs.closeRecordStore();
        } catch(Exception e) {
        }
    }

    // C[v
    public void run() {
        while (true) {
            repaint();
            try {
                Thread.sleep(10);
            } catch (Exception e) {
            }
        }
    }

    //`
    public synchronized void paint(Graphics g) {
        int x, y; // `ʒu
        // wi
        graOff.setColor(BACKCOLOR);
        graOff.fillRect(0,0,getWidth(),getHeight());

        graOff.setColor((255<<16) + (255<<8) + 255); // 
        x = 5;
        y = 2;
        graOff.drawString("GasGuzzler (" + Username + ")"
                          , x
                          , y
                          , g.LEFT|g.TOP);
        y += ADVANCE_Y2;
        graOff.drawString(Year + "/" + Month + "/" + Day
                          , x
                          , y
                          , g.LEFT|g.TOP);

        x = 10;
        y += ADVANCE_Y;
        if(scene == S_DISTANCE1) {
            graOff.setColor((255<<16)); // 
            graOff.drawString("s: " + numStr(Dist1)
                              , x
                              , y
                              , g.LEFT|g.TOP);
        }
        else {
            if(scene == S_DISTANCE2) {
                graOff.setColor((255<<16)); // 
            }
            else {
                graOff.setColor((255<<16) + (255<<8) + 255); // 
            }
            graOff.drawString("s: " + numStr(Dist1) + "." 
                              + numStr2(Dist2)
                              , x
                              , y
                              , g.LEFT|g.TOP);
        }
        y += ADVANCE_Y;
        graOff.setColor((255<<16) + (255<<8) + 255); // 
        if(scene == S_LITER1) {
            graOff.setColor((255<<16)); // 
            graOff.drawString(": " + numStr(Liter1)
                              , x
                              , y
                              , g.LEFT|g.TOP);
        }
        else {
            if(scene == S_LITER2) {
                graOff.setColor((255<<16)); // 
            }
            else {
                graOff.setColor((255<<16) + (255<<8) + 255); // 
            }
            graOff.drawString(": " + numStr(Liter1) + "."
                              + numStr2(Liter2)
                              , x
                              , y
                              , g.LEFT|g.TOP);
        }
        y += ADVANCE_Y;
        if(scene == S_PAY) {
            graOff.setColor((255<<16)); // 
        }
        else {
            graOff.setColor((255<<16) + (255<<8) + 255); // 
        }
        graOff.drawString(": " + Pay.toString()
                          , x
                          , y
                          , g.LEFT|g.TOP);

        graOff.setColor((255<<16) + (255<<8) + 255); // 
        if(!Keido.equals("0")) {
            y += ADVANCE_Y2;
            graOff.drawString(Keido
                              , x
                              , y
                              , g.LEFT|g.TOP);
        }
        if(!Ido.equals("0")) {
            y += ADVANCE_Y;
            graOff.drawString(Ido
                              , x
                              , y
                              , g.LEFT|g.TOP);
        }
        y += ADVANCE_Y2;
        graOff.drawString(msg
                          , x
                          , y
                          , g.LEFT|g.TOP);
        /*
        // debug Message
        y += 20;
        graOff.drawString(Password
                          , x
                          , y
                          , g.LEFT|g.TOP);
        */
        // ItC[W̕\
        g.drawImage(imgOff,0,0,g.LEFT|g.TOP);
    }

    private static StringBuffer buf = new StringBuffer();
    private static String numStr(StringBuffer aBuf) {
        buf.delete(0, buf.length());
        try {
            int num = Integer.parseInt(aBuf.toString());
            buf.append(num);
        }
        catch (Exception e) {
        }
        while(buf.length() < 3) {
            buf.insert(0, 0);
        }
        return buf.toString();
    }
    private static String numStr2(StringBuffer aBuf) {
        buf.delete(0, buf.length());
        try {
            int num = Integer.parseInt(aBuf.toString());
            buf.append(num);
        }
        catch (Exception e) {
        }
        while(buf.length() < 2) {
            buf.append(0);
        }
        return buf.toString();
    }

    private final void setNum(int num) {
        switch (scene) {
        case S_DISTANCE1:
            Dist1.append(num);
            break;
        case S_DISTANCE2:
            Dist2.append(num);
            break;
        case S_LITER1:
            Liter1.append(num);
            break;
        case S_LITER2:
            Liter2.append(num);
            break;
        case S_PAY:
            Pay.append(num);
        }
    }

    // key release
    protected synchronized void keyReleased(int keyCode) {
        if(scene == S_SENDED) { // MĂ珉
            Dist1.delete(0, Dist1.length());
            Dist2.delete(0, Dist2.length());
            Liter1.delete(0, Liter1.length());
            Liter2.delete(0, Liter2.length());
            Pay.delete(0, Pay.length());
            Dist1.append(0);
            Dist2.append(0);
            Liter1.append(0);
            Liter2.append(0);
            Pay.append(0);
            scene = S_DISTANCE1;
        }
        // game actions
        int action = getGameAction(keyCode);

        if(action == FIRE || action == DOWN) {
            scene += 2;
            scene -= scene % 2;
            if(scene > S_PAY) {
                scene = S_DISTANCE1;
            }
        }
        else if(action == UP) {
            scene -= 2;
            scene -= scene % 2;
            if(scene < S_DISTANCE1) {
                scene = S_PAY;
            }
        }
        else if(keyCode == KEY_NUM0) {
            setNum(0);
        }
        else if(keyCode == KEY_NUM1) {
            setNum(1);
        }
        else if(keyCode == KEY_NUM2) {
            setNum(2);
        }
        else if(keyCode == KEY_NUM3) {
            setNum(3);
        }
        else if(keyCode == KEY_NUM4) {
            setNum(4);
        }
        else if(keyCode == KEY_NUM5) {
            setNum(5);
        }
        else if(keyCode == KEY_NUM6) {
            setNum(6);
        }
        else if(keyCode == KEY_NUM7) {
            setNum(7);
        }
        else if(keyCode == KEY_NUM8) {
            setNum(8);
        }
        else if(keyCode == KEY_NUM9) {
            setNum(9);
        }
        else if(keyCode == KEY_STAR || action == RIGHT) { // *
            // _̓
            scene++;
        }
        else if(keyCode == KEY_POUND) { // #
            // clear
            switch (scene) {
            case S_DISTANCE1:
            case S_DISTANCE2:
                Dist1.delete(0, Dist1.length());
                Dist2.delete(0, Dist2.length());
                scene = S_DISTANCE1;
                break;
            case S_LITER1:
            case S_LITER2:
                Liter1.delete(0, Liter1.length());
                Liter2.delete(0, Liter2.length());
                scene = S_LITER1;
                break;
            case S_PAY:
                Pay.delete(0, Pay.length());
            }
        }
        saveCurrentData();
        repaint();
    }

    private final void getGPSdata() {
        Location location;
        //GpsLocation location = null;
        try {
            location = GpsLocation.getLocation();

            Ido = location.getLat();
            Keido = location.getLon();
        }
        catch (Exception e) {
        }
    }

    /* ǂĂ POST ŒʐMł܂ł :(
    private final void sendData_post() {
        String str2 = null;

        HttpConnection con = null;
        InputStream in = null;
        OutputStream out = null;
        try{
            con = (HttpConnection)Connector.open(setUrl);
            con.setRequestMethod(HttpConnection.POST);

            // f[^̑M
            out = con.openOutputStream();
            String postData = new String("user=" + Username
                      + "&pass=" + Password
                      + "&year=" + Year
                      + "&month=" + Month
                      + "&day=" + Day
                      + "&dist1=" + Dist1.toString()
                      + "&dist2=" + Dist2.toString()
                      + "&liter1=" + Liter1.toString()
                      + "&liter2=" + Liter2.toString()
                      + "&pay=" + Pay.toString()
                      + "&ido=" + Ido
                                         + "&keido=" + Keido);
            out.write(postData.getBytes());
            out.flush();

            // f[^̎M
            in = con.openInputStream();
            int length = (int)con.getLength();

            if(length < 0){
                ByteArrayOutputStream _o = new ByteArrayOutputStream();
                byte[] buf = new byte[256];
                int t = 0;
                while((t=in.read(buf))!=-1){
                    _o.write(buf,0,t);
                }
                _o.close();
                str2 = new String(_o.toByteArray());
            }else{
                byte[] buf = new byte[length];
                in.read(buf);
                str2 = new String(buf);
            }
        }
        catch(Exception e) {
            // log(e.toString());
        }
        finally {
            try {
                if(in != null){
                    in.close();
                    in = null;
                }
                if(con!=null){
                    con.close();
                    con = null;
                }
            }
            catch( Exception ee){
            }
        }
        if(str2!=null) {
            msg = str2;
        }
    }
    */
    private final void sendData() {
        String str2 = null;

        HttpConnection con = null;
        InputStream in = null;
        try{

            String _url = setUrl
                + "?do=add"
                + "&user=" + Username
                + "&pass=" + Password
                + "&year=" + Year
                + "&month=" + Month
                + "&day=" + Day
                + "&dist1=" + Dist1.toString()
                + "&dist2=" + Dist2.toString()
                + "&liter1=" + Liter1.toString()
                + "&liter2=" + Liter2.toString()
                + "&pay=" + Pay.toString()
                + "&ido=" + Ido
                + "&keido=" + Keido;

            con = (HttpConnection)Connector.open(_url);
            con.setRequestMethod(HttpConnection.GET);

            in = con.openInputStream();
            int length = (int)con.getLength();

            if(length < 0){
                ByteArrayOutputStream _o = new ByteArrayOutputStream();
                byte[] buf = new byte[256];
                int t = 0;
                while((t=in.read(buf))!=-1){
                    _o.write(buf,0,t);
                }
                _o.close();
                str2 = new String(_o.toByteArray());
            }else{
                byte[] buf = new byte[length];
                in.read(buf);
                str2 = new String(buf);
            }
        }
        catch(Exception e) {
            // log(e.toString());
        }
        finally {
            try {
                if(in != null){
                    in.close();
                    in = null;
                }
                if(con!=null){
                    con.close();
                    con = null;
                }
            }
            catch( Exception ee){
            }
        }
        if(str2!=null) {
            msg = str2;
        }
    }

    //R}hCxg
    public synchronized void commandAction(Command c, Displayable s) {
        if(c == sendCommand) {
            getGPSdata();
            sendData();
            try {
                RecordStore.deleteRecordStore("CurData");
            }
            catch(Exception e) {
            }
            scene = S_SENDED;
        }
        else if(c == dateCommand) {
            DateFieldForm form = new DateFieldForm(midlet, this);
            (Display.getDisplay(midlet)).setCurrent(form);
        }
        else if(c == configCommand) {
            ConfigTextFieldForm form = new ConfigTextFieldForm(midlet
                                                               , this
                                                               , Username
                                                               , Password);
            (Display.getDisplay(midlet)).setCurrent(form);
        }
        else if(c == helpCommand) {
            Alert alert = new Alert("GasGuzzler"
                                    , "_̓: *\nNA: #\n\n$Revision: 1.7 $\n$Date: 2003/03/02 07:31:31 $"
                                    , null, AlertType.INFO);
            alert.setTimeout(Alert.FOREVER);
            (Display.getDisplay(midlet)).setCurrent(alert);
        }
        else if(c == gpsCommand) {
            getGPSdata();
        }
        else if(c == debugCommand) {
            sendData();
        }
    }
}
