/////////////////////////////////////////////////////////////////////
import javax.microedition.lcdui.*;
import java.util.*;
/////////////////////////////////////////////////////////////////////
public class Player {
 public static Game game;
 public static int AI;
 protected static final int d=6;
 public static final int r=5;
 public static final int SPEED=4;
 private static final int hr=4;
 private static final int hd=hr*2;
 private static final int sr=hr-1;
 private static final int sd=sr*2;
 private static final int gr=hr-1;
 private static final int gd=gr*2;
 private static final int fr=gr-1;
 private static final int fd=2*fr;
 private static final int sr3m1=sr*3-1;
 private static final int [] head = {200, 200, 200};
 protected final Point tmp;

 public final Point p;

 protected int f=0;
 protected int fx=hr;
 protected int fy=-fx;
 protected int speed;
 protected int ang;
 private final Group group;
 public int dist;
 protected final Point base;
 //==================================//
 protected Player(Group group) {
  this.group=group;
  p=new Point();
  tmp=new Point();
  base=new Point();
 }//Player-constructor
 //==================================//
 public void init(int bx, int by, int ang, int step){}
 //==================================//
 public void init(int bx, int by, int ang){
  base.init(bx, by);
  p.init(bx, by);
  this.ang=ang;
  speed=0;
 }//init
 //==================================//
 public void setBallPos(Point ball){
  ball.rot(p.x+3, p.y-7, p.x, p.y, ang);
 }//setBallPos
 //==================================//
 public int getDist(){
  return dist=p.getDist(game.ball.p);
 }//getDist
 //==================================//
 public void work(){
  if(game.player!=this||game.isChanged){
   if(game.ball.player==this){
    if(p.x<group.tx)right();
    if(p.y<group.ty)down();
    if(p.y>group.ty)up();
    if(p.x>group.tx)left();
    if(Util.rnd(AI)==0){
     ang=group.getAng();fire();
    }
   }else{
    if(game.ball.player!=null&&game.ball.player.group==this.group){
     if(p.y<game.ball.player.p.y){ang=4; down();}
     else if(p.y>game.ball.player.p.y){ ang=0; up(); }
    }else{
     if(p.x<game.ball.p.x)right();
     if(p.y<game.ball.p.y)down();
     if(p.y>game.ball.p.y)up();
     if(p.x>game.ball.p.x)left();
    }
   }
  }
  if(speed==0)return;
  tmp.init(p.x, p.y);
  switch(ang){
   case 0 : case 8 : p.y-=speed; break;
   case 1 : p.x+=speed; p.y-=speed; break;
   case 2 : p.x+=speed; break;
   case 3 : p.x+=speed; p.y+=speed; break;
   case 4 : p.y+=speed; break;
   case 5 : p.x-=speed; p.y+=speed; break;
   case 6 : p.x-=speed; break;
   case 7 : p.x-=speed; p.y-=speed; break;
  }//ang
  if(!Ground.isFree(p)||game.isCrash(p)) {
   p.init(tmp.x, tmp.y); 
   if(game.player!=this)ang=Util.rnd(Float.max);
  } else if(++f>1){
   fx=-(fy=fx);
   f=0;
  }
 }//work
 //==================================//
 public final void paint(Graphics g, int left, int top){
  int cx=p.x-left;
  int cy=p.y-top;
  int cxphr=cx+hr;
  int cxpsr=cx+sr;
  int cxmsr=cx-sr;

  g.setGrayScale(0);
  tmp.rot(cxpsr, cy+fy, cx, cy, ang);
  g.fillArc(tmp.x-fr, tmp.y-fr, fd, fd, 0, 360);
  tmp.rot(cxmsr, cy+fx, cx, cy, ang);
  g.fillArc(tmp.x-fr, tmp.y-fr, fd, fd, 0, 360);

  tmp.rot(cxmsr, cy, cx, cy, ang);
  drawArc(g, tmp.x, tmp.y, sr, sd, group.colors);

  tmp.rot(cxpsr, cy, cx, cy, ang);
  drawArc(g, tmp.x, tmp.y, sr, sd, group.colors);

  tmp.rot(cx, cy-1, cx, cy, ang);
  drawArc(g, tmp.x, tmp.y, hr, hd, head);
 }//paint
 //==================================//
 private final void drawArc(Graphics g, int x, int y, int r, int d, int [] color){
  g.setColor(color[0], color[1], color[2]);
  g.fillArc(x-r, y-r, d, d, 0, 360);
  g.setGrayScale(0);
  g.drawArc(x-r, y-r, d, d, 0, 360);
 }//grawArc
 //==================================//
 private final void speedUp(){ 
  int s=(game.player==this&&game.ball.player!=this)?5:SPEED;
  if(++speed>s)speed=s; 
 }//speedUp
 //==================================//
 private final void speedDown(){ if(--speed<-1)speed=-1; }//speedDown
 //==================================//
 private final void rotLeft(){ if(speed==0)speed=1; if(--ang<0)ang+=8; }//rotLeft
 //==================================//
 private final void rotRight(){ if(speed==0)speed=1; if(++ang>8)ang-=8;}//rotLeft
 //==================================//
 public final void fire() { 
  if(game.ball.player==this) game.ball.shot(ang);
  else if(p.isInSide(game.ball.p,d)) game.ball.player=this;
 }//fire
 //==================================//
 public final void right( ){
  switch(ang){
   case 0 : case 8 : case 1 : case 7 : rotRight(); return;
   case 3 : case 4 : case 5 : rotLeft(); return;
   case 2 : speedUp(); return;
   case 6 : speedDown(); return;
  }//ang
 }//right
 //==================================//
 public final void left( ){
  switch(ang){
   case 0 : case 8 : case 1 : case 7 : rotLeft(); return;
   case 3 : case 4 : case 5 : rotRight(); return;
   case 2 : speedDown(); return;
   case 6 : speedUp(); return;
  }//ang
 }//left
 //==================================//
 public final void up(){
  switch(ang){
   case 0 : case 8 : speedUp(); return;
   case 4 : speedDown(); return;
   case 1 : case 2  : case 3 : rotLeft(); return;
   case 5 : case 6 : case 7 : rotRight(); return;
  }//ang
 }//up
 //==================================//
 public final void down(){
  switch(ang){
   case 0 : case 8 : speedDown(); return;
   case 4 : speedUp(); return;
   case 1 : case 2 :  case 3 : rotRight(); return;
   case 5 : case 6 : case 7 : rotLeft(); return;
  }//ang
 }//down
}//Player-class
///////////////////////////////AMDG//////////////////////////////////