/////////////////////////////////////////////////////////////////////
import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;
import java.util.*;
/////////////////////////////////////////////////////////////////////
public abstract class Project extends MIDlet implements CommandListener {
 private Gauge speed, level;
 private Image icon;
 private Engine engine;
 //==================================//
 public Project(){
  super();
 }//Project-constructor
 //==================================//
 public final void setScreen(Displayable screen){
  Display.getDisplay(this).setCurrent(screen);
  System.gc();
 }//setScreen
 //==================================//
 protected final void startApp() throws MIDletStateChangeException {
  System.gc();
  Util.init();
  icon=Util.loadImage(getClass().getName());
  RMS.load(getClass().getName());
  engine = new Game(this);
  setScreen(getMenu());
 }//startApp
 //==================================//
 public final void runApp(){
  engine.stop();
  engine.init();
 }//runApp
 //==================================//  
 protected final void pauseApp () {
  engine.stop();
  setScreen(null);
  Form pause=new Form("Paused");
  pause.addCommand(new Command("Continue", Command.OK, 1));
  pause.addCommand(new Command("Menu", Command.CANCEL, 2));
  pause.append(new ImageItem(null, icon, ImageItem.LAYOUT_CENTER, "[icon]"));
  pause.setCommandListener(this);
  setScreen(pause);
 }//pauseApp
 //==================================//  
 protected final void destroyApp(boolean unconditional) throws MIDletStateChangeException {
  if(engine!=null)engine.stop();
  engine=null;
  icon=null;
  speed=level=null;
  setScreen(null);
  RMS.save();
  Util.finalize();
  System.gc();
  notifyDestroyed();
 }//destroyApp
 //==================================//
 private final Form getMenu(){
  Form menu=new Form(getClass().getName());
  menu.append("by Jzsef Tabnyi");
  menu.append(new ImageItem(null, icon, ImageItem.LAYOUT_CENTER, "[icon]"));
  menu.addCommand(new Command("Start", Command.OK, 0));
  menu.addCommand(new Command("Options", Command.ITEM, 1));
  menu.addCommand(new Command("Best score", Command.ITEM , 2));
  menu.addCommand(new Command("About", Command.ITEM, 3));
  menu.addCommand(new Command("Exit", Command.ITEM, 4));
  menu.setCommandListener(this);
  return menu;
 }//getMenu
 //==================================//  
 public synchronized final void commandAction(Command command, Displayable source) {
  if(source == engine){
   pauseApp();
   return;
  }
  String label=command.getLabel();  
  if(label.equals("Start") || label.equals("New")){
   runApp();
   return;
  }
  if(label.equals("Continue")){
   engine.start();
   setScreen(engine);
   return;
  }
  if(label.equals("Exit")) {
   try{ destroyApp( true ); } catch( Exception e ) { }
   return;
  }
  if(label.equals("About")) {
   String str=getClass().getName()+"\nversion: 1.0\nauthor:\nJzsef Tabnyi\nweb:\nextra.hu/tabanyi\nwap:\nweb+/index.wml\nmail:\ntabanyi@extra.hu\nlicense: GNU-GPL\ncopyright (c) 2003";
   Alert about = new Alert(label, str, icon, null);
   about.setTimeout( Alert.FOREVER );
   Display.getDisplay(this).setCurrent( about, source );
   return;
  }
  if(label.equals("Options")) {
   Form options=new Form(label);
   options.append(level=new Gauge("Level", true, 5,  RMS.level));
   options.append(speed=new Gauge("Speed", true, 10, RMS.speed));
   options.addCommand(new Command("OK", Command.BACK, 1));
   options.setCommandListener(this);
   setScreen(options);
   return;
  }
  if(label.equals("Best score")){
   Calendar cal=Calendar.getInstance();
   cal.setTime(new Date(RMS.date));
   Alert score=new Alert(label,"score: "+RMS.score+"\ndate: "+cal, null, null);
   score.setTimeout( Alert.FOREVER );
   Display.getDisplay(this).setCurrent( score, source );
   return;
  }
  if(label.equals("OK")){
   RMS.speed=speed.getValue();
   RMS.level=level.getValue();
   speed=level=null;
  }
  setScreen(getMenu());
 }//commandAction
}//Project-class
///////////////////////////////AMDG//////////////////////////////////