/////////////////////////////////////////////////////////////////////
public final class Float {
 private static final int BIT = 24;
 private static final long ONE= 0x1000000L;
 private static final long MASK = 0xffffffL;
 private static final long NULL = 0L;
 private static final long PI = 0x3243f6aL;
 private static final long RAD = div(PI,toFloat(180));

 public static int dist;
 public static int max;
 public static long [] SIN;
 public static long [] COS;

 //==================================//
 private Float()	{
 }//Float-constructor private!
 //==================================//
 public static void init(int _dist){
  dist=_dist;
  max=360/dist;
  SIN=new long[max];
  COS=new long[SIN.length];
  for(int i=0; i<SIN.length; i++){
   long rad=mul(toFloat(i*dist),RAD);
   SIN[i]=sin(rad);  
   COS[i]=cos(rad);
  }//for
 }//init
 //==================================//
 public static void finalize(){
  SIN=COS=null;
 }//finalize
 //==================================//
 public static long sin(long l) {
  long l1 = mul(l, div(toFloat(180L), PI));
  l1 %= toFloat(360L);
  if(l1 < 0L) l1 = toFloat(360L) + l1;
  long l2 = l1;
  if(l1 >= toFloat(90L) && l1 < toFloat(270L)) l2 = toFloat(180L) - l1;
  else if(l1 >= toFloat(270L) && l1 < toFloat(360L)) l2 = -(toFloat(360L) - l1);
  long l3 = l2 / 90L;
  long l4 = mul(l3, l3);
  long l5 = mul(mul(mul(mul(0xfffffffffffee21aL >> (int)NULL, l4) + (0x14594dL >> (int)NULL), l4) - (0xa55b13L >> (int)NULL), l4) + (long)(0x1921f9c >> (int)NULL), l3);
  return l5;
 }//sin
 //==================================//
 public static long cos(long l) {
	return sin(PI / 2L - l);
 }//cos
 //==================================//
 public static long max(long l, long l1) {
	return l >= l1 ? l : l1;
 }//max
 //==================================//
 public static long div(long l, long l1) {
  boolean flag = false;
  int i = BIT;
  if(l1 == ONE) return l;
  if((l1 & MASK) == 0L) return l / (l1 >> i);
  if(l < 0L && l1 > 0L || l > 0L && l1 < 0L) flag = true;
  if(l < 0L) l = -l;
  if(l1 < 0L) l1 = -l1;
  for(; max(l, l1) >= 1L << 63 - i; i--) { l >>= 1; l1 >>= 1; }
  long l2 = (l << i) / l1 << BIT - i;
  return flag ? -l2 : l2;
 }//div
 //==================================//
 public static long mul(long l, long l1) {
	boolean flag = false;
	int i = BIT;
	long l2 = MASK;
	if((l & l2) == 0L) return (l >> i) * l1;
	if((l1 & l2) == 0L)	return l * (l1 >> i);
	if(l < 0L && l1 > 0L || l > 0L && l1 < 0L) flag = true;
	if(l < 0L) l = -l;
	if(l1 < 0L)	l1 = -l1;
	for(; max(l, l1) >= 1L << 63 - i; i--) {
 	 l >>= 1;
	 l1 >>= 1;
	 l2 >>= 1;
	}//for
	long l3 = (l >> i) * (l1 >> i) << i;
	long l4 = (l & l2) * (l1 & l2) >> i;
	l4 += (l & ~l2) * (l1 & l2) >> i;
	l3 = l3 + l4 + ((l & l2) * (l1 & ~l2) >> i) << BIT - i;
	if(l3 < 0L)	throw new ArithmeticException("Float.mul: overflow");
	else return flag ? -l3 : l3;
 }//mul
 //==================================//
 public static long toFloat(long l) {
	return l << BIT;
 }//toFloat
 //==================================//
 public static long toLong(long l){
	l = round(l, 0);
	return l >> BIT;
 }//toLong
 //==================================//
 public static long round(long l, int i) {
  long l1 = 10L;
  for(int j = 0; j < i; j++) l1 *= 10L;
  l1 = div(toFloat(5L), toFloat(l1));
  if(l < 0L) l1 = -l1;
  return l + l1;
 }//round
}//Float-class
///////////////////////////////AMDG//////////////////////////////////
