/////////////////////////////////////////////////////////////////////
import javax.microedition.lcdui.*;
/////////////////////////////////////////////////////////////////////
public final class Game extends Engine {
 public static final int GTL = Graphics.TOP|Graphics.LEFT;
 public static final int GVH = Graphics.VCENTER|Graphics.HCENTER;
 private static final Image goal=Util.loadImage("goal");
 private final Ground ground;
 private final int cx, cy;
 public int left, top;
 private final PlayersGroup playersGroup;
 private final BotsGroup botsGroup;
 public Player player;
 private Player bot, tmp;
 public final Ball ball;
 private final Target target;
 private Image scoreImage;
 public boolean isChanged;
 private final Clock clock;
 private int goalCounter;
 private boolean goalFlick;
 //==================================//
 public Game(Project project) {
  super(project);
  ground=new Ground();
  Ball.game=this;
  Group.game=this;
  Player.game=this;
  playersGroup=new PlayersGroup();
  botsGroup=new BotsGroup();
  cx=width/2;
  cy=height/2;
  ball=new Ball();
  target=new Target(1);
  clock=new Clock(width);
 }//Game-constructor
 //==================================//
 protected void init(int speed, int level, int score) {
  delay=(10-speed)*10;
  Player.AI=2+(5-level);
  playersGroup.score=botsGroup.score=0;
  clock.init(500);
  middle(playersGroup);
  goalCounter=0;
 }//init
 //==================================//
 private void setScore(){
  String ss=playersGroup.score+":"+botsGroup.score;
  int w=Font.getDefaultFont().stringWidth(ss)+4;
  int x=width-w+1;
  int y=Font.getDefaultFont().getHeight()-2;
  scoreImage=Image.createImage(w, y+1);  
  Graphics g=scoreImage.getGraphics();
  g.drawRect(0, 0, w-2, y);
  g.drawString(ss, 2, 0, GTL);
 }//setScore
 //==================================//
 private void middle(Group group){
  playersGroup.init();
  botsGroup.init();
  player=playersGroup.players[1];
  ball.p.init(Ground.X[6], Ground.Y[7]);
  ball.player=group.players[1];
  left=Ground.X[6]-cx;
  top=Ground.Y[7]-cy;
  isChanged=true;
  setScore();
 }//middle
 //==================================//
 protected void work() {
  if(Util.rnd(Player.AI)==0){
   botsGroup.work();
   playersGroup.work();
  }else{
   playersGroup.work();
   botsGroup.work();
  }
  if(ball.work())return;
//  player=playersGroup.getMostNearlyPlayer(ball.p);
  tmp=playersGroup.getMostNearlyPlayer(ball.p);
  if(player!=tmp){player=tmp;isChanged=true;}
  bot=botsGroup.getMostNearlyPlayer(ball.p);
  tmp=player.dist<bot.dist?player:bot;
  if(tmp.dist<Player.r)ball.player=tmp;

  int l=ball.p.x-cx;
  if(left<l){
   left+=player.speed;
   if(left>l)left=l;
  } else if(left>l){
   left-=player.speed;
   if(left<l)left=l;
  }

  int t=ball.p.y-cy;
  if(top<t){
   top+=player.speed;
   if(top>t)top=t;
  } else if(top>t){
   top-=player.speed;
   if(top<t)top=t;
  }

  ground.work(left, top);
  if(clock.work()){
   int score=playersGroup.score-botsGroup.score;
   if(score<0)score=0;
   stop(score);
  }
 }//work
 //==================================//
 public void playersGoal(){
  playersGroup.score++;
  goalCounter=10;
  middle(botsGroup);
 }//playersGoal
 //==================================//
 public void botsGoal(){
  botsGroup.score++;
  goalCounter=10;
  middle(playersGroup);
 }//botsGoal
 //==================================//
 public void paint(Graphics g){
  g.setColor(0, 255, 0);
  g.fillRect(0, 0, width, height);
  ground.paint(g);
  ball.paint(g, left, top);
  botsGroup.paint(g);
  playersGroup.paint(g);
  target.paint(g, player.p.x-left, player.p.y-top);
  g.drawImage(scoreImage, 0, 0, GTL);
  clock.paint(g);
  if(goalCounter>0){
   goalCounter--;
   if(goalFlick=!goalFlick)
    g.drawImage(goal, cx, cy, GVH);
  }
 }//paint
 //==================================//
 public boolean isCrash(Point p){
  return playersGroup.isCrash(p)||botsGroup.isCrash(p);
 }//isCrash
 //==================================//
 protected void fire() {
  isChanged=false;
  player.fire();
 } //fire
 //==================================//
 protected void right(){
  isChanged=false;
  player.right();
 }//right
 //==================================//
 protected void left(){
  isChanged=false;
  player.left();
 }//left
 //==================================//
 protected void up(){
  isChanged=false;
  player.up();
 }//up
 //==================================//
 protected void down(){
  isChanged=false;
  player.down();
 }//down  
}//Game-class
///////////////////////////////AMDG//////////////////////////////////