/////////////////////////////////////////////////////////////////////
import javax.microedition.lcdui.*;
/////////////////////////////////////////////////////////////////////
public abstract class Group {
 public static Game game;
 public final int [] colors;
 public final Player [] players;
// public final GoalKeeper goalKeeper;
 public final int tx;
 public final int ty;
 public int score;
 //==================================//
 public Group(int tx, int ty) { 
  this.tx=tx;
  this.ty=ty;
  colors=getColors();
  players=new Player[3];
  players[0]=new GoalKeeper(this);
  for(int i=1; i<players.length; i++)
   players[i]=new Player(this);
 }//Group-constructor
 //==================================//
 protected int [] getColors(){
  int [] colors = {255, 0, 0};
  return colors;
 }//getColors
 //==================================//
 public final Player getMostNearlyPlayer(Point p){
  int min=500;
  int index=0;
  for(int i=1; i<players.length; i++){
   players[i].dist=players[i].p.getDist(p);
   if(players[i].dist<=min){
    min=players[i].dist;
    index=i;
   }//if
  }//for
  return players[index];
 }//getMostNearlyPlayer
 //==================================//
 public abstract int getAng();
 //==================================//
 public abstract void init();
 //==================================//
 public final void work(){
  for(int i=0; i<players.length; i++)
   players[i].work();
 }//work
 //==================================//
 public final void paint(Graphics g){
  for(int i=0; i<players.length; i++)
   if(players[i].p.isInSide(game.left, game.top, game.width, game.height))
    players[i].paint(g, game.left, game.top);
 }//paint
 //==================================//
 public final boolean isCrash(Point p){
  for(int i=0; i<players.length; i++)
   if(players[i]!=null&&isCrash(p, players[i].p)) return true;
  return false;
 }//isCrash
 //==================================//
 private final boolean isCrash(Point a, Point b){
  if(a==b)return false;
  return (Math.abs(a.x-b.x)<Player.d&&Math.abs(a.y-b.y)<Player.d);
 }//isCrash
}//Group-class
///////////////////////////////AMDG//////////////////////////////////