/////////////////////////////////////////////////////////////////////
public final class Point {
 public int x,y;
 //==================================//
 public Point(){
  this(0,0);
 }//Point-constructor
 //==================================//
 public Point(int x, int y){
  init(x, y);
 }//Point-constructor
 //==================================//
 public void init(int x, int y){
  this.x=x;
  this.y=y;
 }//init
 //==================================//
 public void rot(int bx, int by, int cx, int cy, int ang){
  this.x=bx;
  this.y=by;
  if(ang==0||ang==Float.max)return;
  long lx=Float.toFloat(bx-cx);
  long ly=Float.toFloat(by-cy);
  long sin=Float.SIN[ang];
  long cos=Float.COS[ang];
  long x=Float.toLong(Float.mul(lx,cos)-Float.mul(ly,sin));
  long y=Float.toLong(Float.mul(ly,cos)+Float.mul(lx,sin));
  this.x=(int)(x+cx);
  this.y=(int)(y+cy);
 }//rot
 //==================================//
 public boolean isInSide(int left, int top, int width, int height){
  return (x>=left&&x<left+width)&&(y>=top&&y<top+height);
 }//isInSide
 //==================================//
 public boolean isInSide(Point p, int range){
  return Math.abs(x-p.x)<range&&Math.abs(y-p.y)<range;
 }//isInSide
 //==================================//
 public int getDist(Point p){
  return (Math.abs(x-p.x)+Math.abs(y-p.y))/2;
 }//getDist
 //==================================//
 public int getAvgX(int px){
  int min=Math.min(x, px);
  return min+Math.abs(x-px)/2;
 }//getAvgX
 //==================================//
 public int getAvgY(int py){
  int min=Math.min(y, py);
  return min+Math.abs(y-py)/2;
 }//getAvgY
}//Point-class
///////////////////////////////AMDG//////////////////////////////////