import javax.microedition.lcdui.*;
import java.util.Random;

final class BlockCanvas extends Canvas
    implements Runnable, CommandListener {
    private final static int
        S_READY = 0,
        S_TITLE = 1,
        S_PLAY = 2,
        S_GAMEOVER = 3,
        S_CLEAR = 4;
    
    private final static int
        H_NONE = 0,
        H_TOP = 1,
        H_BOTTOM = 2,
        H_LEFT = 3,
        H_RIGHT = 4;
    
    private final static int[] SIN = {
        0, 4, 7, 9, 10, 9, 7, 4, 0, -4, -7, -9, -10, -9, -7, -4};
    private final static int[] COS = {
        10, 9, 7, 4, 0, -4, -7, -9, -10, -9, -7, -4, 0, 4, 7, 9};
    
    private Random rand = new Random();
    private Image[] image = new Image[4];
    private int init = S_READY;
    private int scene;
    private String message;
    
    private Image imgOff;
    private Graphics graOff;
    
    private int ballX;
    private int ballY;
    private int ballDir;
    
    private int barX;
    private int barY = getHeight() - 10;
    
    private int blockX = 10 + ((getWidth() - 20) % 20) / 2;
    private int blockY = 10;
    private boolean[][] blockFlag = 
        new boolean[(getHeight() - 40) / 10][(getWidth() - 20) / 20];
    
    public void run() {
        imgOff = Image.createImage(getWidth(), getHeight());
        graOff = imgOff.getGraphics();
        
        addCommand(new Command("START", Command.SCREEN, 0));
        setCommandListener(this);
        
        try {
            for(int i = 2; i >= 0; i--) {
                image[i] = Image.createImage("/" + i + ".png");
            }
        }
        catch (Exception e) {
        }
        
        init = S_TITLE;
        while(true) {
            repaint();
            try {
                Thread.sleep(10);
            }
            catch (Exception e) {
            }
        }
    }
    
    public synchronized void paint(Graphics g) {
        int i, j, dx, dy, hit;
        
        if(init >= 0) {
            if(init == S_READY) {
                return;
            }
            scene = init;
            init = -1;
            message = null;
            
            // title
            if(scene == S_TITLE) {
                message = "MIMI BLOCK";
                ballX = getWidth() * 10 / 2;
                ballY = getHeight() * 10 - 200;
                ballDir = ((rand.nextInt() >>> 1) % 5 + 14) % 16;
                barX = getWidth() / 2;
                for(j = 0; j < blockFlag.length; j++) {
                    for(i = 0; i < blockFlag[0].length; i++) {
                        blockFlag[j][i] = true;
                    }
                }
            }
            
            // game over
            if(scene == S_GAMEOVER) {
                message = "GAME OVER";
            }
            
            // clear
            if(scene == S_CLEAR) {
                message = "CLEAR!!";
            }
        }
        
        if(scene == S_PLAY) {
            // move ball
            ballX += SIN[ballDir] * 6;
            ballY -= COS[ballDir] * 6;
            
            // hit
            hit = H_NONE;
            // hit bar
            if(barY + 8 > ballY / 10 
               && ballY / 10 > barY
               && barX - 10 <= ballX / 10
               && ballX / 10 <= barX + 10) {
                ballY = getHeight() * 10 - 100;
                hit = H_BOTTOM;
            }
            else if(ballY < 50) {
                ballY = 50;
                hit = H_TOP;
            }
            else if(ballX < 50) { // right
                ballX = 50;
                hit = H_LEFT;
            }
            else if(ballX > getWidth() * 10 - 50) { // left
                ballX = getWidth() * 10 - 50;
                hit = H_RIGHT;
            }
            else { // block
                dx = (ballX / 10 - blockX) / 20;
                dy = (ballY / 10 - blockY) / 10;
                if(0 <= dx && dx < blockFlag[0].length &&
                   0 <= dy && dy < blockFlag.length &&
                   blockFlag[dy][dx]) {
                    
                    blockFlag[dy][dx] = false;
                    if(ballDir >= 8) {
                        hit = H_LEFT;
                        if (ballX / 10 < blockX + dx * 20 + 10) {
                            hit = H_BOTTOM;
                            if(ballDir >= 14) {
                                hit = H_TOP;
                            }
                        }
                    }
                    else {
                        hit = H_RIGHT;
                        if(blockX + dx * 20 + 10 <= ballX / 10) {
                            hit = H_TOP;
                            if(ballDir >= 4) {
                                hit = H_BOTTOM;
                            }
                        }
                    }
                }
            }
            // shototsu
            if(hit == H_TOP) { // up
                if(ballDir >= 8) {
                    ballDir = 8 + (16 - ballDir);
                }
                else {
                    ballDir = 8 - ballDir;
                }
            }
            else if (hit == H_LEFT) { // left 
                if(ballDir >= 12) {
                    ballDir = (16 - ballDir);
                }
                else {
                    ballDir = 8 - (ballDir -8);
                }
            }
            else if(hit == H_RIGHT) { // right
                if(ballDir >= 4) {
                    ballDir = 8 + (8 - ballDir);
                }
                else {
                    ballDir = 16 - ballDir;
                }
            }
            else if(hit == H_BOTTOM) { // bottom
                if(ballDir >= 8) {
                    ballDir = 16 - (ballDir - 8);
                }
                else {
                    ballDir = 8 - ballDir;
                }
                j = (ballDir + 15 + (rand.nextInt() >>> 1) % 3) % 16;
                if(j != 4 && j != 12) {
                    ballDir = j;
                }
            }
            
            // result
            if(ballY / 10 > getHeight()) {
                init = S_GAMEOVER;
            }
            hit = 0;
            for(j = 0; j < blockFlag.length; j++) {
                for(i = 0; i < blockFlag[0].length; i++) {
                    if(blockFlag[j][i]) {
                        hit = 1;
                    }
                }
            }
            if (hit == 0) {
                init = S_CLEAR;
            }
        }
        
        // off image
        graOff.setColor((255 << 16) + (255 << 8) + 255);
        graOff.fillRect(5, 5, getWidth() - 10, getHeight() -5);
        graOff.drawImage(image[2], getWidth() / 2, 10, 
                         g.HCENTER | g.TOP);
        
        // ball
        graOff.setColor((55 << 16) + (55 << 8) + 255);
        graOff.fillArc(ballX / 10 - 2, ballY / 10 - 2, 5, 5, 0, 360);
        
        // bar
        graOff.drawImage(image[0], barX, barY, g.HCENTER | g.TOP);
        
        // block
        for(j = 0; j < blockFlag.length; j++) {
            for(i = 0; i < blockFlag[0].length; i++) {
                if(blockFlag[j][i]) {
                    graOff.drawImage(image[1]
                                     , blockX + i * 20
                                     , blockY + j * 10
                                     , g.LEFT | g.TOP);
                }
            }
        }
        
        // waku
        graOff.setColor((255 << 16) + (80 << 8) + 80);
        graOff.fillRect(0, 0, getWidth(), 5);
        graOff.fillRect(0, 5, 5, getHeight() - 5);
        graOff.fillRect(getWidth() - 5, 5, 5, getHeight() - 5);
        
        // message
        if(message != null) {
            graOff.setColor((255 << 16) + (150 << 8) + 150);
            graOff.drawString(message, getWidth() / 2 + 1
                              , 20, g.HCENTER | g.TOP);
            graOff.drawString(message, getWidth() / 2 - 1
                              , 20, g.HCENTER | g.TOP);
            graOff.drawString(message, getWidth() / 2
                              , 20 + 1, g.HCENTER | g.TOP);
            graOff.drawString(message, getWidth() / 2
                              , 20 - 1, g.HCENTER | g.TOP);
            graOff.setColor((255<< 16));
            graOff.drawString(message, getWidth() / 2
                              , 20, g.HCENTER | g.TOP);
        }
        
        g.drawImage(imgOff, 0, 0, g.LEFT | g.TOP);
    }
    
    protected synchronized void keyPressed(int keyCode) {
        if(scene == S_PLAY) {
            int action = getGameAction(keyCode);
            if(action == LEFT) { // move bar left
                barX -= 10;
                if(barX < 10) {
                    barX = 10;
                }
            }
            else if(action == RIGHT) { //move bar right
                barX += 10;
                if(barX > getWidth() - 10) {
                    barX = getWidth() - 10;
                }
            }
        }
    }
    
    // command ivent
    public synchronized void commandAction(Command c, Displayable s) {
        if(scene == S_TITLE) {
            init = S_PLAY;
        }
        if(scene == S_GAMEOVER || scene == S_CLEAR) {
            init = S_TITLE;
        }
    }
}





