import javax.microedition.lcdui.*;

final class Spheres{
    public int Vx = 0;
    public int Vy = 0;
    public int X;
    public int Y;
    public int M;
    public Image[] img;
    public int ImageNum;
    public int ImageMAX;

    public int GoalX, GoalY;
    public int DispX, DispY;

    static final int Scale = 100;
    static final int Grav = 50;
    static final int Limit = 30;

    public Spheres(String filename, int imageNum, int x, int y) {
        img = new Image[imageNum + 1];
        try {
            for(int i = imageNum; i >= 0; i--) {
                img[i] = Image.createImage(filename + i + ".png");
            }
        }
        catch (Exception e) {
        }

        DispX = x;
        DispY = y;
        GoalX = X = DispX * Scale / 2;
        GoalY = Y = DispY * Scale / 2;

        ImageMAX = imageNum;
        ImageNum = 0;
        M = 1;
    }
    public void moveSphere() {
	int dx, dy;
	int ax, ay;
	int absx,absy;

	dx = GoalX - X;
	dy = GoalY - Y;

	if(dx < 0){
	    absx = -dx;
	}
	else{
	    absx = dx;
	}
	if(dy < 0){
	    absy = -dy;
	}
	else{
	    absy = dy;
	}
	int abs = absx + absy;
	if(abs != 0){
	    ax = Grav * dx / abs;
	    ay = Grav * dy / abs;
	}
	else {
	    ax = ay = 0;
	}

	Vx += ax;
	Vy += ay;

	Vx = (Vx * 95) / 100;
	Vy = (Vy * 95) / 100;
	if(Vx > -Limit && Vx < Limit
	   && dx > -Limit && dx < Limit) {
	    Vx = 0;
	    GoalX = X;
	}
	if(Vy > -Limit && Vy < Limit
	   && dy > -Limit && dy < Limit) {
	    Vy = 0;
	    GoalY = Y;
	}

	X += Vx;
	Y += Vy;
    }

}
