import java.lang.Math;
import javax.microedition.lcdui.*;

// double buffering (canvas)
public class SpheresCanvas extends Canvas
    implements Runnable {
    // Spheres
    private Spheres Bozu;
    private Spheres Yuki;
    
    // double buffering
    private Image imgOff; // off image
    private Graphics graOff; // off graphics
    
    // Constructor
    public SpheresCanvas() {
        Bozu = new Spheres("/bozu", 23, getWidth(), getHeight());
        Yuki = new Spheres("/yuki", 13, getWidth(), getHeight());
        
        Bozu.GoalX = Bozu.X = Bozu.DispX * Bozu.Scale / 2;
        Bozu.GoalY = Bozu.Y = Bozu.DispY * Bozu.Scale / 2;
        
        Bozu.M = 3;
        
        Yuki.Vx = 1000;
        Yuki.X = 0;
        Yuki.Y = 0;
        Yuki.GoalX = Bozu.X;
        Yuki.GoalY = Bozu.Y;
        Yuki.M = 2;
        
        
        // double buffering
        imgOff = Image.createImage(getWidth(), getHeight());
        graOff = imgOff.getGraphics();
    }
    
    // key press events
    protected synchronized void keyPressed(int keyCode) {
        // game actions
        int action = getGameAction(keyCode);
        if(action == UP) {
            Bozu.GoalY -= 10 * Bozu.Scale;
        }
        else if (action == DOWN) {
            Bozu.GoalY += 10 * Bozu.Scale;
        }
        else if(action == LEFT) {
            Bozu.GoalX -= 10 * Bozu.Scale;
        }
        else if(action == RIGHT) {
            Bozu.GoalX += 10 * Bozu.Scale;
        }
        else if(action == FIRE) {
            Bozu.GoalX = Bozu.DispX * Bozu.Scale / 2;
            Bozu.GoalY = Bozu.DispY * Bozu.Scale / 2;
        }
        if(Bozu.GoalX < 0) {
            Bozu.GoalX = 0;
        }
        else if(Bozu.GoalX > Bozu.DispX * Bozu.Scale) {
            Bozu.GoalX = Bozu.DispX * Bozu.Scale;
        }
        if(Bozu.GoalY < 0) {
            Bozu.GoalY = 0;
        }
        else if(Bozu.GoalY > Bozu.DispY * Bozu.Scale) {
            Bozu.GoalY = Bozu.DispY * Bozu.Scale;
        }
    }
    
    private void doImpact(Spheres a, Spheres b) {
        /*
          a.Vx = b.Vx -a.Vx;
          a.Vy = b.Vy -a.Vy;
          b.Vx = -2 * b.Vx;
          b.Vy = -2 * b.Vy;
        */
        
        int avx = a.Vx;
        int avy = a.Vy;
        int bvx = b.Vx;
        int bvy = b.Vy;
        int R = 1;
        
        b.Vx = (2 * a.M * avx + b.M * bvx -a.M * bvx) / (a.M + b.M);
        b.Vy = (2 * a.M * avy + b.M * bvy -a.M * bvy) / (a.M + b.M);
        
        a.Vx = -avx + bvx + b.Vx;
        a.Vy = -avy + bvy + b.Vy;
        
        a.Vx = (a.Vx * 5) / 4;
        a.Vy = (a.Vy * 5) / 4;
        b.Vx = (b.Vx * 5) / 3;
        b.Vy = (b.Vy * 5) / 3;
        
    }
    private boolean checkImpact(Spheres a, Spheres b) {
        if(Math.abs(a.X - b.X) < 1600 && Math.abs(a.Y - b.Y) < 1600) {
            return true;
        }
        return false;
    }
    
    // draw
    public void paint(Graphics g) {
        // check off image create
        if(graOff == null) {
            return;
        }
        
        Bozu.moveSphere();
        Yuki.GoalX = Bozu.X;
        Yuki.GoalY = Bozu.Y;
        Yuki.moveSphere();
        
        if(checkImpact(Bozu, Yuki)) {
            doImpact(Bozu, Yuki);
            do {
                Bozu.moveSphere();
                Yuki.GoalX = Bozu.X;
                Yuki.GoalY = Bozu.Y;
                Yuki.moveSphere();
            } while(checkImpact(Bozu, Yuki) 
                    && (Bozu.Vx != 0 && Bozu.Vy != 0)
                    && (Yuki.Vx != 0 && Yuki.Vy != 0)
                    );
        }
        
        // draw
        graOff.setColor(0);
        graOff.fillRect(0, 0, getWidth(), getHeight());
        
        graOff.drawImage(Bozu.img[Bozu.ImageNum++]
                         , Bozu.X / Bozu.Scale
                         , Bozu.Y / Bozu.Scale, g.HCENTER | g.VCENTER);
	if (Bozu.ImageNum > Bozu.ImageMAX) {
	    Bozu.ImageNum = 0;
	}
        
        
        graOff.drawImage(Yuki.img[Yuki.ImageNum++]
                         , Yuki.X / Yuki.Scale
                         , Yuki.Y / Yuki.Scale, g.HCENTER | g.VCENTER);
	if (Yuki.ImageNum > Yuki.ImageMAX) {
	    Yuki.ImageNum = 0;
	}
        
        g.drawImage(imgOff, 0, 0, g.LEFT | g.TOP);
    }
    
    // execute
    public void run() {
        
        // main loop
        while(true) {
            repaint();
            try {
                Thread.sleep(10);
            }
            catch(Exception e) {
            }
        }
    }
    
}
