import javax.microedition.lcdui.*;
import java.util.Random;

// panel game (canvas)
final class PanelCanvas extends Canvas {
    // double buffering
    private static Image imgOff; // off image
    private static Graphics graOff; // off graphics

    // variables
    private static Random rand = new Random();
    private static Image[] image = new Image[25];
    private static int[] data = new int[25];

    // Constructor
    PanelCanvas() {
        int i, j, k;
        Image imgPic = null;

        // read image
        try {
            imgPic = Image.createImage("/mimi.png");
        }
        catch (Exception e) {
        }

        // making piece images
        for(i = 24; i >= 0; i--) {
            image[i] = Image.createImage(20, 20);
            image[i].getGraphics().drawImage(imgPic
                                             , -20 * (i % 5)
                                             , -20 * (i / 5)
                                             , Graphics.LEFT | Graphics.TOP);
        }
        // piece data
        for(i = 24; i >= 0; i--) {
            data[i] = i;
        }
        int [] dir = {UP, DOWN, LEFT, RIGHT};
        for(i = 99; i >= 0; i--) {
            controlPanel(dir[(rand.nextInt() >>> 1) % 4]);
        }
        // double buffering
        imgOff = Image.createImage(getWidth(), getHeight());
        graOff = imgOff.getGraphics();
    }

    // draw
    public void paint(Graphics g) {
        int i, j;
       
        // check off image
        if(graOff == null) {
            return;
        }

        // back ground
        graOff.setColor((247 << 16) + (148 << 8) + 29);
        graOff.fillRect(0, 0, 160, 140);
        graOff.setColor((255 << 16) + (255 << 8));
        graOff.fillRect(
            (getWidth() - 100) / 2
            ,(getHeight() - 100) / 2
            , 100, 100);

        // image
        for(i = 24; i >= 0; i--) {
            if(data[i] != 24) {
                graOff.drawImage(image[data[i]]
                                 , (getWidth() - 100) / 2 + 20 * (i % 5)
                                 , (getHeight() - 100) / 2 + 20 * (i / 5)
                                 , g.LEFT | g.TOP);
            }
        }
        // result check
        j = 0;
        for(i = 24; i >= 0; i--) {
            if(data[i] != i) {
                j = 1;
            }
        }
        if(j == 0) {
            graOff.setColor((255 << 16));
            graOff.drawString("Complete!!!"
                              , getWidth() / 2
                              , (getHeight() - 100) / 2 + 5
                              , g.HCENTER | g.TOP);
            graOff.drawImage(image[24]
                             , (getWidth() - 100) / 2 + 20 * 4
                             , (getHeight() - 100) / 2 + 20 * 4
                             , g.LEFT | g.TOP);
        }
        g.drawImage(imgOff, 0, 0, g.LEFT | g.TOP);
    }

    // key press events
    protected synchronized void keyPressed(int keyCode) {
        controlPanel(getGameAction(keyCode));
        repaint();
    }
    
    // panel
    private void controlPanel(int action) {
        int i;
        for(i = 24; i >= 0; i--) {
            if(data[i] == 24) {
                break;
            }
        }
        // swap data
        if(action == UP && i / 5 < 4) {
            data[i] = data[i+5];
            data[i+5] = 24;
        }
        else if(action == DOWN && i / 5 > 0) {
            data[i] = data[i-5];
            data[i-5] = 24;
        }
        else if(action == LEFT && i % 5 < 4) {
            data[i] = data[i+1];
            data[i+1] = 24;
        }
        else if(action == RIGHT && i % 5 > 0) {
            data[i] = data[i-1];
            data[i-1] = 24;
        }
    }
}
