import javax.microedition.lcdui.*;

// double buffering (canvas)
final class BozuCanvas extends Canvas
    implements Runnable {
    // informations
    /*
    private int x = 20;
    private int y = 20;
    */
    private int VX = 0;
    private int VY = 0;
    private int ImageX, ImageY;
    private int GoalX, GoalY;
    private int DispX, DispY;
    /*
    private int Bx = 0;
    private int By = 0;
    */
    static final int Scale = 100;
    static final int Grav = 40;
    static final int Limit = 30;

    // double buffering
    private Image imgOff; // off image
    private Graphics graOff; // off graphics

    private final int IMAGEMAX = 24;
    
    private static Image[] image = new Image[24];
    private int ImageNum = 0;
    
    // Constructor
    public BozuCanvas() {
        try {
            for(int i = 1; i <= 24; i++) {
                if(i < 10) {
                    image[i-1] = Image.createImage("/bozu0" + i + ".png");
                }
                else {
                    image[i-1] = Image.createImage("/bozu" + i + ".png");
                }
            }
        }
        catch (Exception e) {
        }
        DispX = getWidth();
        DispY = getHeight();
        GoalX = ImageX = DispX * Scale / 2;
        GoalY = ImageY = DispY * Scale / 2;
        // double buffering
        imgOff = Image.createImage(DispX, DispY);
        graOff = imgOff.getGraphics();
    }

    // key press events
    protected synchronized void keyPressed(int keyCode) {
        // game actions
        int action = getGameAction(keyCode);
        if(action == UP) {
            GoalY -= 10 * Scale;
        }
        else if (action == DOWN) {
            GoalY += 10 *Scale;
        }
        else if(action == LEFT) {
            GoalX -= 10 * Scale;
        }
        else if(action == RIGHT) {
            GoalX += 10 * Scale;
        }
        else if(action == FIRE) {
            GoalX = DispX * Scale / 2;
            GoalY = DispY * Scale / 2;
        }
        if(GoalX < 0) {
            GoalX = 0;
        }
        else if(GoalX > DispX * Scale) {
            GoalX = DispX * Scale;
        }
        if(GoalY < 0) {
            GoalY = 0;
        }
        else if(GoalY > DispY * Scale) {
            GoalY = DispY * Scale;
        }
    }
    private void moveBozu() {
	int dx, dy;
	int ax, ay;
	int absx,absy;

	dx = GoalX - ImageX;
	dy = GoalY - ImageY;

	if(dx < 0){
	    absx = -dx;
	}
	else{
	    absx = dx;
	}
	if(dy < 0){
	    absy = -dy;
	}
	else{
	    absy = dy;
	}
	int abs = absx + absy;
	if(abs != 0){
	    ax = Grav * dx / abs;
	    ay = Grav * dy / abs;
	}
	else {
	    ax = ay = 0;
	}

	VX += ax;
	VY += ay;

	VX = (VX * 95) / 100;
	VY = (VY * 95) / 100;
	if(VX > -Limit && VX < Limit
	   && dx > -Limit && dx < Limit) {
	    VX = 0;
	    GoalX = ImageX;
	}
	if(VY > -Limit && VY < Limit
	   && dy > -Limit && dy < Limit) {
	    VY = 0;
	    GoalY = ImageY;
	}

	ImageX += VX;
	ImageY += VY;
	
    }

    // draw
    public void paint(Graphics g) {
        // check off image create
        if(graOff == null) {
            return;
        }
        /*
        // move
        x += dx;
        y += dy;
        if(x <= 0 || x >= getWidth()) {
            dx = -dx;
        }
        if(y <= 0 || y >= getHeight()) {
            dy = - dy;
        }
        */
        moveBozu();
        // draw
        graOff.setColor(0);
        graOff.fillRect(0, 0, DispX, DispY);
        //graOff.setColor(255 << 16);
        //graOff.drawString("TAKE", x, y, g.HCENTER | g.BOTTOM);
        graOff.drawImage(image[ImageNum++], ImageX / Scale, ImageY / Scale, g.HCENTER | g.VCENTER);
	if (ImageNum >= IMAGEMAX) {
	    ImageNum = 0;
	}
        g.drawImage(imgOff, 0, 0, g.LEFT | g.TOP);
    }

    // execute
    public void run() {

        // main loop
        while(true) {
            repaint();
            /*
            try {
                Thread.sleep(10);
            }
            catch(Exception e) {
            }
            */
        }
    }
}
