/*
 * ConfigForm.java
 * $Id: ConfigForm.java,v 1.2 2003/09/07 06:04:30 take Exp $
 * 
 * Copyright Studio High-Score All Rights Reserved.
 *
 */
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

/**
 * ConfigForm
 *
 * @author TAKEchi Masashi
 * @version
 */
final class ConfigForm extends Form
    implements CommandListener {

    private MIDlet midlet;
    private SunCompassCanvas sunCanvas;

    private TextField timezoneField;

    public ConfigForm(MIDlet midlet, SunCompassCanvas sunCanvas) {
        super("Configuration");

        this.midlet = midlet;
        this.sunCanvas = sunCanvas;

        timezoneField = new TextField("Timezone (hour)"
                                      , Integer.toString(sunCanvas.timezone)
                                      , 2, TextField.NUMERIC);
        append(timezoneField);

        addCommand(new Command("set", Command.SCREEN, 0));
        setCommandListener(this);
    }

    //R}hCxg
    public synchronized void commandAction(Command c, Displayable s) {
        sunCanvas.timezone = Integer.parseInt(timezoneField.getString());
        sunCanvas.saveHighScore();

        (Display.getDisplay(midlet)).setCurrent(sunCanvas);
    }
}
