/*
 * SunCompassCanvas.java
 * $Id: SunCompassCanvas.java,v 1.2 2003/09/07 06:04:30 take Exp $
 * 
 * Copyright Studio High-Score All Rights Reserved.
 *
 */
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.rms.*;
import javax.microedition.io.*;
import java.util.*;
import java.util.Random;

/**
 * SunCompassCanvas
 * CLoX
 *
 * @author TAKEchi Masashi
 * @version
 */
public final class SunCompassCanvas extends Canvas
    implements Runnable,CommandListener {
    
    private Random rand = new Random();
    
    //_uobt@O
    private Image imgOff;//ItC[W
    private Graphics graOff;//ItOtBNX
    
    private MIDlet midlet;
    
    private final int BACKCOLOR = 0x000000;
    private final int SUNCOLOR = 0xffff00;
    private final int GAUGECOLOR = 0x00ff00;
    private final int FONTCOLOR = 0x00ff00;
    
    private final int FIX = 100;
    private final int DAY_SECOND = 24 * 60 * 60;
    private final int RMARGIN = 10;
    private int RFMARGIN;

    private final int STEP = 1000;
    private final int STEP2 = 6000;
    
    private int getWidth;
    private int getHeight;
    //private int fontHeight;
    private int rf;
    private int r0;
    private int r1;
    private int r2;
    private int rs;
    private int rs2;
    private int rn;
    private int xc;
    private int yc;
    private int goalDir = -1;
    private int curDir;
    private int aDir;
    private int vDir;
    
    private long sec;
    
    private int sunDir; // 0 -359
    private final int northDir = 0;
    
    public int timezone;
    
    // Constructor
    public SunCompassCanvas(MIDlet midlet) {
        this.midlet = midlet;
        
        addCommand(new Command("Config", Command.SCREEN, 1));
        addCommand(new Command("About", Command.SCREEN, 2));
        setCommandListener(this);
        
        getWidth = getWidth();
        getHeight = getHeight();
        
        int width = getWidth;
        int height = getHeight;

        // double buffering
        imgOff = Image.createImage(getWidth, getHeight);
        graOff = imgOff.getGraphics();

        Font font = Font.getFont(Font.FACE_MONOSPACE
                                 , Font.STYLE_PLAIN, Font.SIZE_SMALL);
        graOff.setFont(font);
        RFMARGIN = font.getHeight() / 2 - 1;
        
        xc = width / 2;
        yc = height / 2;
        if(xc < yc) {
            r0 = xc - RMARGIN;
            rf = xc - RFMARGIN / 2;
        }
        else {
            r0 = yc - RMARGIN;
            rf = yc - RFMARGIN / 2;
        }
        RFMARGIN++;
        r1 = (r0 * 8) / 10;
        r2 = (r0 * 9) / 10;
        rs = (r0 * 7) / 10;
        rs2 = r0 / 2;
        rn = r0 / 10;

        vDir = 5000;

        loadHighScore();
    }
    public void saveHighScore() {
        try {
            RecordStore rs = RecordStore.openRecordStore("SunCompass", true);
            byte[] b = Integer.toString(timezone).getBytes();
            if(rs.getNumRecords() == 0) {
                rs.addRecord(b, 0, b.length);
            }
            else {
                rs.setRecord(1, b, 0, b.length);
            }
            rs.closeRecordStore();
        } catch(Exception e) {
        }
    }
    private void loadHighScore() {
        try {
            RecordStore rs = RecordStore.openRecordStore("SunCompass", false);
            timezone = Integer.parseInt(new String(rs.getRecord(1)));
            rs.closeRecordStore();
        } catch(Exception e) {
            timezone = 9;
            saveHighScore();
        }
    }
    // C[v
    public void run() {
        while (true) {
            repaint();
            try {
                Thread.sleep(100);
            }
            catch (Exception e) {
            }
        }
    }
    
    // draw
    public void paint(Graphics g) {
        // check off image create
        if(graOff == null) {
            return;
        }
        
        calcSunDir();
        
        // draw
        graOff.setColor(BACKCOLOR);
        graOff.fillRect(0, 0, getWidth, getHeight);

        aDir = goalDir - curDir;
        vDir += aDir;
        vDir = (vDir * 8) / 10;

        curDir += vDir;

        //        int dir = curDir;
        int nx = xc + (r0 * cos((northDir + curDir) / FIX)) / FIX;
        int ny = yc + (r0 * sin((northDir + curDir) / FIX)) / FIX;
        int n1x = xc + (rn * cos((northDir + curDir + 9000) / FIX)) / FIX;
        int n1y = yc + (rn * sin((northDir + curDir + 9000) / FIX)) / FIX;
        int n2x = xc + (rn * cos((northDir + curDir - 9000) / FIX)) / FIX;
        int n2y = yc + (rn * sin((northDir + curDir - 9000) / FIX)) / FIX;

        graOff.setColor(0xffffff);
        graOff.drawLine(nx, ny, n1x, n1y);
        graOff.drawLine(nx, ny, n2x, n2y);
        graOff.drawLine(n1x, n1y, n2x, n2y);
        nx = xc + (rf * cos((northDir + curDir) / FIX)) / FIX;
        ny = yc + (rf * sin((northDir + curDir) / FIX)) / FIX + RFMARGIN;

        graOff.setColor(GAUGECOLOR);
        graOff.drawString("N"
                          , nx
                          , ny
                          , g.HCENTER|g.BOTTOM);
        graOff.setColor(GAUGECOLOR);

        /*
        nx = xc + (r0 * cos((northDir + curDir + 18000)/ FIX)) / FIX;
        ny = yc + (r0 * sin((northDir + curDir + 18000)/ FIX)) / FIX;
        n1x = xc + (r1 * cos((northDir + curDir + 18000)/ FIX)) / FIX;
        n1y = yc + (r1 * sin((northDir + curDir + 18000)/ FIX)) / FIX;
        graOff.drawLine(n1x, n1y, nx, ny);
        */
        nx = xc + (rf * cos((northDir + curDir + 18000)/ FIX)) / FIX;
        ny = yc + (rf * sin((northDir + curDir + 18000)/ FIX)) / FIX +RFMARGIN;
        graOff.drawString("S"
                          , nx
                          , ny
                          , g.HCENTER|g.BOTTOM);

        /*
        nx = xc + (r0 * cos((northDir + curDir + 9000)/ FIX)) / FIX;
        ny = yc + (r0 * sin((northDir + curDir + 9000)/ FIX)) / FIX;
        n1x = xc + (r1 * cos((northDir + curDir + 9000)/ FIX)) / FIX;
        n1y = yc + (r1 * sin((northDir + curDir + 9000)/ FIX)) / FIX;
        graOff.drawLine(n1x, n1y, nx, ny);
        */
        n2x = xc + (rf * cos((northDir + curDir + 9000)/ FIX)) / FIX;
        n2y = yc + (rf * sin((northDir + curDir + 9000)/ FIX)) / FIX +RFMARGIN;
        graOff.drawString("E"
                          , n2x
                          , n2y
                          , g.HCENTER|g.BOTTOM);
        /*
        nx = xc + (r0 * cos((northDir + curDir + 27000)/ FIX)) / FIX;
        ny = yc + (r0 * sin((northDir + curDir + 27000)/ FIX)) / FIX;
        n1x = xc + (r1 * cos((northDir + curDir + 27000)/ FIX)) / FIX;
        n1y = yc + (r1 * sin((northDir + curDir + 27000)/ FIX)) / FIX;
        graOff.drawLine(n1x, n1y, nx, ny);
        */
        n2x = xc + (rf * cos((northDir + curDir + 27000)/ FIX)) / FIX;
        n2y = yc + (rf * sin((northDir + curDir + 27000)/ FIX)) / FIX+RFMARGIN;
        graOff.drawString("W"
                          , n2x
                          , n2y
                          , g.HCENTER|g.BOTTOM);

        for(int i = 1000; i < 36000; i += 1000) {
            drawMeter(i);
        }
        drawMeter(3000, "3");
        drawMeter(6000, "6");
        //drawMeter(9000, "E");
        drawMeter(12000, "12");
        drawMeter(15000, "15");
        //drawMeter(18000, "S");
        drawMeter(21000, "21");
        drawMeter(24000, "24");
        //drawMeter(27000, "W");
        drawMeter(30000, "30");
        drawMeter(33000, "33");

        graOff.setColor(SUNCOLOR);

        int sx = xc + (r1 * cos((sunDir + curDir)/ FIX)) / FIX;
        int sy = yc + (r1 * sin((sunDir + curDir)/ FIX)) / FIX;
        int s1x = xc + (rs * cos((sunDir + curDir + 500)/ FIX)) / FIX;
        int s1y = yc + (rs * sin((sunDir + curDir + 500)/ FIX)) / FIX;
        int s2x = xc + (rs * cos((sunDir + curDir - 500)/ FIX)) / FIX;
        int s2y = yc + (rs * sin((sunDir + curDir - 500)/ FIX)) / FIX;
        
        graOff.drawLine(s1x, s1y, s2x, s2y);
        graOff.drawLine(sx, sy, s1x, s1y);
        graOff.drawLine(sx, sy, s2x, s2y);

        sx = xc + (rs2 * cos((sunDir + curDir)/ FIX)) / FIX;
        sy = yc + (rs2 * sin((sunDir + curDir)/ FIX)) / FIX + RFMARGIN;
        graOff.drawString("Sun"
                          , sx
                          , sy
                          , g.HCENTER|g.BOTTOM);


        g.drawImage(imgOff, 0, 0, g.LEFT | g.TOP);
    }
    private void drawMeter(int angle, String num) {
        int nx = xc + (rf * cos((northDir + curDir + angle)/ FIX)) / FIX;
        int ny = yc + (rf * sin((northDir + curDir + angle)/ FIX)) / FIX+RFMARGIN;
        graOff.drawString(Integer.toString(angle / 1000)
                          , nx
                          , ny
                          , graOff.HCENTER|graOff.BOTTOM);
    }
    private void drawMeter(int angle) {
        int n1x;
        int n1y;

        int nx = xc + (r0 * cos((northDir + curDir + angle)/ FIX)) / FIX;
        int ny = yc + (r0 * sin((northDir + curDir + angle)/ FIX)) / FIX;
        if(angle % 3000 == 0) {
            n1x = xc + (r1 * cos((northDir + curDir + angle)/ FIX)) / FIX;
            n1y = yc + (r1 * sin((northDir + curDir + angle)/ FIX)) / FIX;
        }
        else {
            n1x = xc + (r2 * cos((northDir + curDir + angle)/ FIX)) / FIX;
            n1y = yc + (r2 * sin((northDir + curDir + angle)/ FIX)) / FIX;
        }
        //graOff.setColor(GAUGECOLOR);
        graOff.drawLine(n1x, n1y, nx, ny);

    }

    private int sin(int t) {
        while(t < 0) {
            t += 360;
        }
        while(t >= 360) {
            t -= 360;
        }
        return sin[t];
    }
    private int cos(int t) {
        while(t < 0) {
            t += 360;
        }
        while(t >= 360) {
            t -= 360;
        }
        return cos[t];
    }
    
    
    private void calcSunDir() {
        /**/
        TimeZone tz = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance(tz);
        /*
          int year = calendar.get(Calendar.YEAR);
          int month = calendar.get(Calendar.MONTH);
          int day = calendar.get(Calendar.DATE);
        */

        sec = (calendar.get(Calendar.HOUR_OF_DAY) + timezone) * 3600
            + calendar.get(Calendar.MINUTE) * 60
            + calendar.get(Calendar.SECOND);
        /*
        sec = 6 * 3600;
        */
        sunDir = (int)((sec * FIX) / DAY_SECOND) * 360;
        if(goalDir == -1) {
            goalDir = 27000 - sunDir;
        }
    }

    // key press events
    protected synchronized void keyPressed(int keyCode) {
        // game actions
        int action = getGameAction(keyCode);
        if(action == UP) {
            goalDir += STEP2;
        }
        else if (action == DOWN) {
            goalDir -= STEP2;
        }
        else if(action == RIGHT) {
            goalDir += STEP;
        }
        else if(action == LEFT) {
            goalDir -= STEP;
        }
        else if(action == FIRE) {
            goalDir = 27000 - sunDir;
        }
    }

    //R}hCxg
    public synchronized void commandAction(Command c, Displayable s) {
        if(c.getPriority() == 1) { // config
            ConfigForm form = new ConfigForm(midlet, this);
            (Display.getDisplay(midlet)).setCurrent(form);
        }
        else if(c.getPriority() == 2) { // about
            Alert alert = new Alert("SunCompass"
                                    , "Find the north direction depending on the current sun position.\n"
                                    + "You can use to move UP, DOWN, LEFT, RIGHT and FIRE keys.\n"
                                    + "\nTAKEchi Masashi (take@TAKEchon.NET)\nhttp://www.TAKEchon.NET/\n$Revision: 1.2 $\n$Date: 2003/09/07 06:04:30 $"
                                    , null, AlertType.INFO);
            alert.setTimeout(Alert.FOREVER);
            (Display.getDisplay(midlet)).setCurrent(alert);
        }
    }
    // ̓fO[ (0` 359)
    private final int[] sin = {
        0, 1, 3, 5, 6, 8, 10, 12, 13, 15, 
        17, 19, 20, 22, 24, 25, 27, 29, 30, 32, 
        34, 35, 37, 39, 40, 42, 43, 45, 46, 48, 
        49, 51, 52, 54, 55, 57, 58, 60, 61, 62, 
        64, 65, 66, 68, 69, 70, 71, 73, 74, 75, 
        76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
        86, 87, 88, 89, 89, 90, 91, 92, 92, 93, 
        93, 94, 95, 95, 96, 96, 97, 97, 97, 98, 
        98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 
        100, 99, 99, 99, 99, 99, 99, 99, 99, 98, 
        98, 98, 97, 97, 97, 96, 96, 95, 95, 94, 
        93, 93, 92, 92, 91, 90, 89, 89, 88, 87, 
        86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 
        76, 75, 74, 73, 71, 70, 69, 68, 66, 65, 
        64, 62, 61, 60, 58, 57, 55, 54, 52, 51, 
        49, 48, 46, 45, 43, 42, 40, 39, 37, 35, 
        34, 32, 30, 29, 27, 25, 24, 22, 20, 19, 
        17, 15, 13, 12, 10, 8, 6, 5, 3, 1, 
        0, -1, -3, -5, -6, -8, -10, -12, -13, -15, 
        -17, -19, -20, -22, -24, -25, -27, -29, -30, -32, 
        -34, -35, -37, -39, -40, -42, -43, -45, -46, -48, 
        -50, -51, -52, -54, -55, -57, -58, -60, -61, -62, 
        -64, -65, -66, -68, -69, -70, -71, -73, -74, -75, 
        -76, -77, -78, -79, -80, -81, -82, -83, -84, -85, 
        -86, -87, -88, -89, -89, -90, -91, -92, -92, -93, 
        -93, -94, -95, -95, -96, -96, -97, -97, -97, -98, 
        -98, -98, -99, -99, -99, -99, -99, -99, -99, -99, 
        -100, -99, -99, -99, -99, -99, -99, -99, -99, -98, 
        -98, -98, -97, -97, -97, -96, -96, -95, -95, -94, 
        -93, -93, -92, -92, -91, -90, -89, -89, -88, -87, 
        -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, 
        -76, -75, -74, -73, -71, -70, -69, -68, -66, -65, 
        -64, -62, -61, -60, -58, -57, -55, -54, -52, -51, 
        -50, -48, -46, -45, -43, -42, -40, -39, -37, -35, 
        -34, -32, -30, -29, -27, -25, -24, -22, -20, -19, 
        -17, -15, -13, -12, -10, -8, -6, -5, -3, -1, 
    };
    private final int[] cos = {
        100, 99, 99, 99, 99, 99, 99, 99, 99, 98, 
        98, 98, 97, 97, 97, 96, 96, 95, 95, 94, 
        93, 93, 92, 92, 91, 90, 89, 89, 88, 87, 
        86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 
        76, 75, 74, 73, 71, 70, 69, 68, 66, 65, 
        64, 62, 61, 60, 58, 57, 55, 54, 52, 51, 
        50, 48, 46, 45, 43, 42, 40, 39, 37, 35, 
        34, 32, 30, 29, 27, 25, 24, 22, 20, 19, 
        17, 15, 13, 12, 10, 8, 6, 5, 3, 1, 
        0, -1, -3, -5, -6, -8, -10, -12, -13, -15, 
        -17, -19, -20, -22, -24, -25, -27, -29, -30, -32, 
        -34, -35, -37, -39, -40, -42, -43, -45, -46, -48, 
        -49, -51, -52, -54, -55, -57, -58, -60, -61, -62, 
        -64, -65, -66, -68, -69, -70, -71, -73, -74, -75, 
        -76, -77, -78, -79, -80, -81, -82, -83, -84, -85, 
        -86, -87, -88, -89, -89, -90, -91, -92, -92, -93, 
        -93, -94, -95, -95, -96, -96, -97, -97, -97, -98, 
        -98, -98, -99, -99, -99, -99, -99, -99, -99, -99, 
        -100, -99, -99, -99, -99, -99, -99, -99, -99, -98, 
        -98, -98, -97, -97, -97, -96, -96, -95, -95, -94, 
        -93, -93, -92, -92, -91, -90, -89, -89, -88, -87, 
        -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, 
        -76, -75, -74, -73, -71, -70, -69, -68, -66, -65, 
        -64, -62, -61, -60, -58, -57, -55, -54, -52, -51, 
        -50, -48, -46, -45, -43, -42, -40, -39, -37, -35, 
        -34, -32, -30, -29, -27, -25, -24, -22, -20, -19, 
        -17, -15, -13, -12, -10, -8, -6, -5, -3, -1, 
        0, 1, 3, 5, 6, 8, 10, 12, 13, 15, 
        17, 19, 20, 22, 24, 25, 27, 29, 30, 32, 
        34, 35, 37, 39, 40, 42, 43, 45, 46, 48, 
        50, 51, 52, 54, 55, 57, 58, 60, 61, 62, 
        64, 65, 66, 68, 69, 70, 71, 73, 74, 75, 
        76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
        86, 87, 88, 89, 89, 90, 91, 92, 92, 93, 
        93, 94, 95, 95, 96, 96, 97, 97, 97, 98, 
        98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 
    };
}
