/*
 * TurnDropCanvas.java
 * $Id: TurnDropCanvas.java,v 1.4 2003/09/03 12:40:42 take Exp $
 * 
 * Copyright Studio High-Score All Rights Reserved.
 *
 */
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.rms.*;
import javax.microedition.io.*;
import java.util.*;
import java.util.Random;

/**
 * TurnDropCanvas
 * CLoX
 *
 * @author TAKEchi Masashi
 * @version
 */
public final class TurnDropCanvas extends Canvas
    implements Runnable,CommandListener {
    
    private Random rand = new Random();
    
    //_uobt@O
    private Image imgOff;//ItC[W
    private Graphics graOff;//ItOtBNX
    
    private MIDlet midlet;
    
    private final int BACKCOLOR = 0x000000;
    private final int CURCOLOR1 = 0xffffff;
    private final int CURCOLOR2 = 0xaaaaaa;
    
    private final int NONE = -1;
    private final int RED = 0;
    private final int GREEN = 1;
    private final int BLUE = 2;
    private final int YELLOW = 3;
    
    private int[][] board = new int[10][10];
    private int[] pri = new int[100];
    
    private Image[][] sImage = new Image[4][5];
    
    private int getWidth;
    private int getHeight;
    private int x0;
    private int y0;
    
    private int curX;
    private int curY;
    
    private int level;
    private boolean isStart;
    private boolean isEnd;
    //private boolean isTurn;
    //private int move;
    private int loop;
    private final int LOOP_D = 1;
    private int loopd = LOOP_D;
    private int loopWait;
    private int score;
    private int hiScore;
    private boolean isHiScore;

    // Constructor
    public TurnDropCanvas(MIDlet midlet) {
        this.midlet = midlet;
        
        addCommand(new Command("Start", Command.SCREEN, 1));
        addCommand(new Command("About", Command.SCREEN, 2));
        addCommand(new Command("High-Score", Command.SCREEN, 3));
        setCommandListener(this);

        getWidth = getWidth();
        getHeight = getHeight();
        
        x0 = (getWidth - 100) / 2;
        y0 = (getHeight - 100) /2;
        
        curX = curY = 5;
        
        // double buffering
        imgOff = Image.createImage(getWidth, getHeight);
        graOff = imgOff.getGraphics();

        try {
            for(int j = 3; j >= 0; j--) {
                for(int i = 4; i >= 0; i--) {
                    sImage[j][i] 
                        = Image.createImage("/" + Integer.toString(j) 
                                            + Integer.toString(i) + ".png");
                }
            }
        }
        catch (Exception e) {
        }
        for(int i = 99; i >= 0; i--) {
            pri[i] = i;
        }
        level = 59;
        isStart = false;
        isHiScore = false;
        loadHighScore();
    }
    private void saveHighScore() {
        try {
            RecordStore rs = RecordStore.openRecordStore("TurnDrop", true);
            byte[] b = Integer.toString(hiScore).getBytes();
            if(rs.getNumRecords() == 0) {
                rs.addRecord(b, 0, b.length);
            }
            else {
                rs.setRecord(1, b, 0, b.length);
            }
            rs.closeRecordStore();
        } catch(Exception e) {
        }
    }
    private void loadHighScore() {
        try {
            RecordStore rs = RecordStore.openRecordStore("TurnDrop", false);
            hiScore = Integer.parseInt(new String(rs.getRecord(1)));
            rs.closeRecordStore();
        } catch(Exception e) {
        }
    }

    private void makeBoard(int level) {
        int x, y, c;
        for(x = 9; x >= 0; x--) {
            for(y = 9; y >= 0; y--) {
                //board[x][y] = ((rand.nextInt() >>> 1) % 5) - 1;
                board[x][y] = NONE;
            }
        }
        for(int i = 99; i >= 0; i--) {
            x = (rand.nextInt() >>> 1) % 100;
            y = (rand.nextInt() >>> 1) % 100;
            c = pri[x];
            pri[x] = pri[y];
            pri[y] = c;
        }
        for(int i = level; i >= 0; i--) {
            c = (rand.nextInt() >>> 1) % 4;
            x = pri[i] / 10;
            y = pri[i] % 10;
            board[x][y] = c;
        }
        isHiScore = false;
        isEnd = false;
        loop = 0;
        loopWait = 3000;
        loopd = LOOP_D;
        score = 0;
    }
    private void putSphere() {
        int x, y;
        boolean endCheck;
        endCheck = true;
        for(int i = 99; i >= 0; i--) {
            x = pri[i] / 10;
            y = pri[i] % 10;
            if(board[x][y] == NONE) {
                board[x][y] = (rand.nextInt() >>> 1) % 4;
                endCheck = false;
                break;
            }
        }
        if(endCheck) {
            isEnd = true;
        }
        if(isEnd) {
            //makeBoard(level);
            if(score > hiScore) {
                isHiScore = true;
                hiScore = score;
                saveHighScore();
            }
            board[(rand.nextInt() >>> 1) % 10][(rand.nextInt() >>> 1) % 10]
                = (rand.nextInt() >>> 1) % 4;
        }
    }
    // C[v
    public void run() {
        while (true) {
            repaint();
            try {
                Thread.sleep(100);
                if(++loop > loopWait / 100) {
                    putSphere();
                    loop = 0;
                    loopWait -= loopd;
                    loopd += LOOP_D;
                    if(loopWait < 0) {
                        loopWait = 0;
                    }
                }
                    
            }
            catch (Exception e) {
            }
        }
    }
    
    // draw
    public void paint(Graphics g) {
        // check off image create
        if(graOff == null) {
            return;
        }

        // draw
        graOff.setColor(BACKCOLOR);
        graOff.fillRect(0, 0, getWidth, getHeight);

        if(!isStart) {
            graOff.setColor(0xff0000);
            for(int i = -1; i <= 1; i++) {
                for(int j = -1; j <= 1; j++) {
                    graOff.drawString("TurnDrop"
                                      ,getWidth / 2 + i
                                      ,getHeight / 2 - 11 + j
                                      ,g.HCENTER|g.TOP);
                    graOff.drawString("by TAKEchi M."
                                      ,getWidth() / 2 + i
                                      ,getHeight() / 2 + j
                                      ,g.HCENTER|g.TOP);
                    graOff.drawString("with Studio High-Score"
                                      ,getWidth() / 2 + i
                                      ,getHeight() / 2 + 11 + j
                                      ,g.HCENTER|g.TOP);
                }
            }
            graOff.setColor(0xffffff);
            graOff.drawString("TurnDrop"
                              ,getWidth / 2
                              ,getHeight / 2 - 11
                              ,g.HCENTER|g.TOP);
            graOff.drawString("by TAKEchi M."
                              ,getWidth() / 2
                              ,getHeight() / 2
                              ,g.HCENTER|g.TOP);
            graOff.drawString("with Studio High-Score"
                              ,getWidth() / 2
                              ,getHeight() / 2 + 11
                              ,g.HCENTER|g.TOP);
            g.drawImage(imgOff, 0, 0, g.LEFT | g.TOP);
            return;
        }
        int color;
        for(int x = 9; x >= 0; x--) {
            for(int y = 9; y >= 0; y--) {
                if((color = board[x][y]) != NONE) {
                    //isEnd = false;
                    if(isEnd) {
                        graOff.drawImage(sImage[color][0]
                                         , x * 10 + x0
                                         , y * 10 + y0
                                         , graOff.LEFT|graOff.TOP);
                    }
                    else if(curX == x && curY == y) {
                        graOff.drawImage(sImage[color][3]
                                         , x * 10 + x0
                                         , y * 10 + y0
                                         , graOff.LEFT|graOff.TOP);
                    }
                    else if(curX == x + 1 && curY == y) {
                        graOff.drawImage(sImage[color][4]
                                         , x * 10 + x0
                                         , y * 10 + y0
                                         , graOff.LEFT|graOff.TOP);
                    }
                    else if(curX == x + 1 && curY == y + 1) {
                        graOff.drawImage(sImage[color][1]
                                         , x * 10 + x0
                                         , y * 10 + y0
                                         , graOff.LEFT|graOff.TOP);
                    }
                    else if(curX == x && curY == y + 1) {
                        graOff.drawImage(sImage[color][2]
                                         , x * 10 + x0
                                         , y * 10 + y0
                                         , graOff.LEFT|graOff.TOP);
                    }
                    else {
                        graOff.drawImage(sImage[color][0]
                                         , x * 10 + x0
                                         , y * 10 + y0
                                         , graOff.LEFT|graOff.TOP);
                    }
                }
            }
        }
        
        // cursor
        if(!isEnd) {
            graOff.setColor(CURCOLOR2);
            graOff.fillRect(curX * 10 + x0 - 1, curY * 10 + y0 - 1, 2, 2);
            graOff.setColor(CURCOLOR1);
            graOff.fillRect(curX * 10 + x0 - 1, curY * 10 + y0 - 1, 1, 1);
        }
        else {
            graOff.setColor(0xff0000);
            for(int i = -1; i <= 1; i++) {
                for(int j = -1; j <= 1; j++) {
                    graOff.drawString("GAME OVER"
                                      ,getWidth / 2 + i
                                      ,getHeight / 2 + j
                                      ,g.HCENTER|g.TOP);
                    if(isHiScore) {
                        graOff.drawString("High-Score!! " + score
                                          , getWidth + i
                                          , getHeight +j
                                          , graOff.RIGHT | graOff.BOTTOM);
                    }
                    else {
                        graOff.drawString("SCORE: " + score
                                          , getWidth + i
                                          , getHeight +j
                                          , graOff.RIGHT | graOff.BOTTOM);
                    }
                }
            }
            graOff.setColor(0xffffff);
            graOff.drawString("GAME OVER"
                              ,getWidth / 2
                              ,getHeight / 2
                              ,g.HCENTER|g.TOP);
            if(isHiScore) {
                graOff.drawString("High-Score!! " + score
                                  , getWidth
                                  , getHeight
                                  , graOff.RIGHT | graOff.BOTTOM);
            }
            else {
                graOff.drawString("SCORE: " + score
                                  , getWidth
                                  , getHeight
                                  , graOff.RIGHT | graOff.BOTTOM);
            }
        }

        g.drawImage(imgOff, 0, 0, g.LEFT | g.TOP);
    }
    // key press events
    protected synchronized void keyPressed(int keyCode) {
        if(isEnd) {
            return;
        }
        // game actions
        int action = getGameAction(keyCode);
        if(action == UP) {
            curY--;
            if(curY <= 0) {
                curY = 1;
            }
            /*
            else if(isTurn) {
                putSphere();
                isTurn = false;
            }
            else if(++move > 2) {
                putSphere();
                isTurn = false;
                move = 0;
            }
            */
        }
        else if (action == DOWN) {
            curY++;
            if(curY >= 10) {
                curY = 9;
            }
            /*
            else if(isTurn) {
                putSphere();
                isTurn = false;
            }
            else if(++move > 2) {
                putSphere();
                isTurn = false;
                move = 0;
            }
            */
        }
        else if(action == LEFT) {
            curX--;
            if(curX <= 0) {
                curX = 1;
            }
            /*
            else if(isTurn) {
                putSphere();
                isTurn = false;
            }
            else if(++move > 2) {
                putSphere();
                isTurn = false;
                move = 0;
            }
            */
        }
        else if(action == RIGHT) {
            curX++;
            if(curX >= 10) {
                curX = 9;
            }
            /*
            else if(isTurn) {
                putSphere();
                isTurn = false;
            }
            else if(++move > 2) {
                putSphere();
                isTurn = false;
                move = 0;
            }
            */
        }
        else if(action == FIRE) {
            if(board[curX][curY] == board[curX][curY - 1]
               && board[curX][curY] == board[curX - 1][curY - 1]
               && board[curX][curY] == board[curX - 1][curY]) {
                if(board[curX][curY] != NONE) {
                    putSphere();
                    score++;
                }
                board[curX][curY] = NONE;
                board[curX][curY - 1] = NONE;
                board[curX - 1][curY - 1] = NONE;
                board[curX - 1][curY] = NONE;
            }
            else{
                turn(curX, curY);
                //isTurn = true;
            }
        }
    }
    private void turn(int x, int y) {
        int tmp = board[x][y];
        board[x][y] = board[x][y - 1];
        board[x][y - 1] = board[x - 1][y - 1];
        board[x - 1][y - 1] = board[x - 1][y];
        board[x - 1][y] = tmp;
    }
    //R}hCxg
    public synchronized void commandAction(Command c, Displayable s) {
        if(c.getPriority() == 1) { // start
            if(isEnd) {
                makeBoard(level);
            }
            isStart = true;
        }
        else if(c.getPriority() == 2) { // about
            Alert alert = new Alert("TurnDrop"
                                    , "邭񂵂ďĂ!\n"
                                    + ": J[\ړ\n"
                                    + "NbN: FȂ\n"
                                    + "@@@@@ႤFȂ]\n"
                                    + "\nTAKEchi Masashi (take@TAKEchon.NET)\nhttp://www.TAKEchon.NET/\n$Revision: 1.4 $\n$Date: 2003/09/03 12:40:42 $"
                                    , null, AlertType.INFO);
            alert.setTimeout(Alert.FOREVER);
            (Display.getDisplay(midlet)).setCurrent(alert);
        }
        else if(c.getPriority() == 3) { // high-score
            Alert alert = new Alert("High-Score"
                                    , "High-Score is: " 
                                    + Integer.toString(hiScore)
                                    , null, AlertType.INFO);
            alert.setTimeout(Alert.FOREVER);
            (Display.getDisplay(midlet)).setCurrent(alert);
        }
    }
}
