/*
 * iTimeCanvas.java
 * $Id: iTimeCanvas.java,v 1.3 2003/06/28 02:16:26 take Exp $
 * 
 * Copyright Studio High-Score All Rights Reserved.
 *
 */
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.util.TimeZone;
import java.util.Calendar;

/**
 * iTimeCanvas
 * CLoX
 *
 * @author TAKEchi Masashi
 * @version
 */
public final class iTimeCanvas extends Canvas
    implements Runnable,CommandListener {
    
    private final int TIMEDIFF = 1;
    private final int BACKCOLOR = 0xffffff;

    Command aboutCommand;

    //_uobt@O
    private Image imgOff;//ItC[W
    private Graphics graOff;//ItOtBNX

    private MIDlet midlet;
    private final int imageW = 25;
    private final int imageH = 30;
    private final int imageNum = 11;
    private Image[] numImage = new Image[imageNum];

    private int dx;
    private int dy;

    // Constructor
    public iTimeCanvas(MIDlet midlet) {
        this.midlet = midlet;
        aboutCommand = new Command("ABOUT", Command.SCREEN, 2);

        addCommand(aboutCommand);
        setCommandListener(this);

        dx = (getWidth() - imageW * 4) / 2 - 1;
        dy = (getHeight() - imageH) / 2 - 1;

        // double buffering
        imgOff = Image.createImage(getWidth(), getHeight());
        graOff = imgOff.getGraphics();

        try {
            for(int i = imageNum -1; i >= 0; i--) {
                numImage[i] 
                    = Image.createImage("/n" + Integer.toString(i) + ".png");
            }
        }
        catch (Exception e) {
        }
    }

    // C[v
    public void run() {
        while (true) {
            repaint();
            try {
                Thread.sleep(10);
            } catch (Exception e) {
            }
        }
    }

    // draw
    public void paint(Graphics g) {
        // check off image create
        if(graOff == null) {
            return;
        }
        // draw
        graOff.setColor(BACKCOLOR);
        graOff.fillRect(0, 0, getWidth(), getHeight());

        int beats = calcInternetTime();
        graOff.drawImage(numImage[10]
                         , dx
                         , dy
                         , g.LEFT|g.TOP);
        graOff.drawImage(numImage[(int)(beats / 100)]
                         , dx + imageW
                         , dy
                         , g.LEFT|g.TOP);
        graOff.drawImage(numImage[(int)(beats / 10) % 10]
                         , dx + imageW * 2
                         , dy
                         , g.LEFT|g.TOP);
        graOff.drawImage(numImage[beats % 10]
                         , dx + imageW * 3
                         , dy
                         , g.LEFT|g.TOP);
        g.drawImage(imgOff, 0, 0, g.LEFT | g.TOP);
    }

    public int calcInternetTime() {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        Calendar today = Calendar.getInstance(tz);
        
        int second = today.get(Calendar.SECOND);
        int minute = today.get(Calendar.MINUTE);
        int hour = today.get(Calendar.HOUR_OF_DAY);

        hour = (hour + 24 + TIMEDIFF) % 24;
        int secs = (int)((hour * 3600)
                         + (minute * 60)
                         + second
                         );
        int beats = (secs * 10) / 864;
        return beats;
    }

    //R}hCxg
    public synchronized void commandAction(Command c, Displayable s) {
        if(c == aboutCommand) {
            Alert alert = new Alert("iTime"
                                    , "TAKEchi Masashi (take@TAKEchon.NET)\nhttp://www.TAKEchon.NET/\n$Revision: 1.3 $\n$Date: 2003/06/28 02:16:26 $"
                                    , null, AlertType.INFO);
            alert.setTimeout(Alert.FOREVER);
            (Display.getDisplay(midlet)).setCurrent(alert);
        }
    }
}
