#!/usr/bin/perl
use Time::Local;

#+++GPS+++
#906631744,135.239424,34.957004
#906631753,135.239424,34.956967
#906631761,135.239456,34.956988
#906631773,135.239338,34.957047

#1Ĥϥॹס1980ǯ1600ʬ0áפÿ

$inFile = $ARGV[0];
$outFile = $ARGV[1];

if($inFile eq "") {
  &usage;
  exit;
}

if($outFile eq "") {
  $outFile = $inFile . ".kml";
}

open(INFILE, "$inFile");
open(OUTFILE, ">$outFile");

&writeHeader;

$lastlon = 0;
$lastlat = 0;
$readFlg = 0;
while ($line = <INFILE>) {
  chomp($line);
  chop ($line) if ($line =~ /\r$/);
  chop ($line) if ($line =~ /\n$/);
  chop ($line) if ($line =~ /\r$/);
  if($line =~ m/\+\+\+GPS.*/) {
	print "start\n";
	$readFlg = 1;
	next;
  }
  if($readFlg) {
	($gpstime, $lon, $lat)=split(/,/, $line);
	if($startTime == 0) {
	  $startTime = &calcTime($gpstime);
	  $slon = $lon;
	  $slat = $lat;
	}
	$curtime = &calcTime($gpstime);
	$curDate = &time2str($curtime);
	if($lon != $lastlon || $lat != $lastlat) {
	  print OUTFILE "                        $lon,$lat <!-- $curDate -->\n";
	  $lastlon = $lon;
	  $lastlat = $lat;
	}
  }
}
print OUTFILE <<"ROUTEEND";
                    </coordinates>
                </LineString>
            </Placemark>
ROUTEEND

# start point
print OUTFILE "            <Placemark>\n";
print OUTFILE "                <name>Start point</name>\n";

$startDate = &time2str($startTime);
print OUTFILE "                <description>Date: $startDate</description>\n";
print OUTFILE "                <styleUrl>#start</styleUrl>\n";
print OUTFILE "                <Point>\n";
print OUTFILE "                    <coordinates>$slon,$slat</coordinates>\n";
print OUTFILE "                </Point>\n";
print OUTFILE "            </Placemark>\n";

# goal point
print OUTFILE "            <Placemark>\n";
print OUTFILE "                <name>Goal point</name>\n";

$goaltime = &calcTime($gpstime);
$goalDate = &time2str($goaltime);
print OUTFILE "                <description>Date: $goalDate</description>\n";
print OUTFILE "                <styleUrl>#goal</styleUrl>\n";
print OUTFILE "                <Point>\n";
print OUTFILE "                    <coordinates>$lon,$lat</coordinates>\n";
print OUTFILE "                </Point>\n";
print OUTFILE "            </Placemark>\n";

# footer
print OUTFILE "        </Folder>\n";
print OUTFILE "    </Document>\n";
print OUTFILE "</kml>\n";

close(INFILE);
close(OUTFILE);

exit;

sub writeHeader {
  print OUTFILE <<"HEADER";
<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://earth.google.com/kml/2.1">
    <Document>
        <Style id="route">
            <LineStyle>
                <color>770000ff</color>
                <width>6</width>
            </LineStyle>
        </Style>
        <Style id="start">
            <IconStyle>
                <scale>1</scale>
                <icon>
                    <href>http://www.takechon.net/take64a.png</href>
                </icon>
            </IconStyle>
        </Style>
        <Style id="goal">
            <IconStyle>
                <scale>1</scale>
                <icon>
                    <href>http://www.takechon.net/take64a.png</href>
                </icon>
            </IconStyle>
        </Style>
        <Folder>
            <Placemark>
                <styleUrl>#route</styleUrl>
                <LineString>
                    <coordinates>
HEADER
}

sub calcTime {
  local ($gtime) = @_;

  $basetime = timelocal(0,0,0,6,0,1980);
  return $basetime + $gtime;
}

sub time2str {
  local ($nowtime) = @_;

  ($sec,$min,$hour,$day,$month,$year,$wday,$yday,$isdst)=localtime($nowtime);

  $month++;
  $year += 1900;

  $datestr = sprintf("%04d/%02d/%02d %02d:%02d:%02d",
					 $year, $month, $day, $hour, $min, $sec);
}

sub usage {
  print "gpslog2kml.pl <infile> <outfile>\n";
}
