#! /usr//bin/perl
use Time::Local;

#require "/Users/take/bin/mime/mimer.pl";
#require '/Users/take/bin/jcode.pl';
#$srcDir = "/Users/take/Calendar/schedule";
#$VcalFileName = "/Users/take/work/tmp/killme/today.vcs";

require "/home/take/public_html/mycgi/mime/mimer.pl";
require '/home/take/public_html/mycgi/jcode.pl';
$srcDir = "/home/take/Calendar/schedule";
$VcalFileName = "/home/take/work/today.vcs";


$ENV{'TZ'} = "JST-9";
#
# դΥå
#
($nowsec,$nowmin,$nowhour,$nowmday,$nowmon,$nowyear,$nowwday,$nowyday,$nowisdst) = localtime(time);

$nowyear += 1900;
$nowmon++;

$startYear = $nowyear;
$startMonth = $nowmon;

$targetDate = sprintf("%04d%02d%02d", $nowyear, $nowmon, $nowmday);
#$nowmday;

print "start $startYear $startMonth\n";

$writeFlg = 0;
open(VCAL, ">$VcalFileName");
&header;

$PHASE = 0; # normal schedule
    print "$nowyear, $nowmon\n";

    $fromDir = sprintf("$srcDir/%04d/%02d/", $nowyear, $nowmon);
    #print "$fromDir\n";

    foreach $i (1 .. 100) {
	$targetFile = $fromDir . $i;
	if (-e $targetFile) {
	    #print "$targetFile\n";

	    &convVcal($targetFile);
	}
    }

    $nowmon ++;
    if($nowmon > 12) {
	$nowyear++;
	$nowmon -= 12;
    }


## intersect 
$PHASE = 1; # intersect
$fromDir = "$srcDir/intersect/";
#print "$fromDir\n";

foreach $i (1 .. 1000) {
    $targetFile = $fromDir . $i;
    if (-e $targetFile) {
	#print "$targetFile\n";
	&convVcal($targetFile);
    }
}

&footer;
close(VCAL);

if($writeFlg == 0) {
  unlink($VcalFileName);
}

exit;

sub convVcal
{
    local ($inFile) = @_;

    open(FILE, $inFile);
    @lines = <FILE>;
    close(FILE);

    $SUMMARY = "";
    $DESCRIPTION = "";
    $CATEGORIES = "";
    $sTime = $eTime = 0;
    $aTime = $aUnit = 0;


    foreach $line (@lines){
	&jcode'convert(*line,'sjis'); #'#ɤ euc 
	if($line =~ m/^X-SC-(.*)/) {
	    ($head, $data) = split (/\s/, $1, 2);
	    #($head, $data) = split (/\s/, $1);
	    if($head eq "Subject:"
	       || $head eq "Location:") {
		#$data = &mimedecode($data, "EUC");
		$data = &mimedecode($data, "SJIS"); ################
	    }
	    #print "$head -> $data\n";
	    if($head eq "Subject:") {
		$SUMMARY = "SUMMARY:$data\r\n";
	    }
	    elsif($head eq "Cond:") { # Jan 27
		($temp, @Conds) = split (/\s/, $line);
	    }
	    elsif($head eq "Location:") {
		$DESCRIPTION = "DESCRIPTION:$data\r\n";
	    }
	    elsif($head eq "Day:") {
		($temp, @Days) = split (/\s/, $line);
		#$day = $data; # 20030124
		#print ">>>>>day $day\n"; ##################
	    }
	    elsif($head eq "Time:") {
		($sTime, $eTime) = split(/-/, $data, 2);
	    }
	    elsif($head eq "Category:") {
		$CATEGORIES = "CATEGORIES:$data\r\n";
	    }
	    elsif($head eq "Alarm:") {
		($aTime, $aUnit) = split(/\s/, $data, 2);
		if($aUnit ne "") {
		    if($aUnit =~ m/minute/i) {
			$aTime *= 60;
		    }
		    elsif($aUnit =~ m/hour/i) {
			$aTime = $aTime * 60 * 60;
		    }
		    elsif($aUnit =~ m/day/i) {
			$aTime = $aTime * 24 * 60 * 60;
		    }
		}
		else {
		    $aTime = -1; # 顼ʤ
		}
	    }
	}
    }
    &calTime;
}

sub writeVcal
{
  #open(VCAL, ">$VcalFileName");
  #&header;
    print VCAL "BEGIN:VEVENT\r\n";

    print VCAL $SUMMARY;
    print VCAL $DESCRIPTION;
    print VCAL $CATEGORIES;

    print VCAL $DTSTART;
    print VCAL $DTEND;
    print VCAL $AALARM;

    print VCAL "CLASS:PUBLIC\r\n";
    print VCAL "END:VEVENT\r\n";
    #&footer;
    #close(VCAL);
}

sub calTime
{
    local ($y, $m);

    if($PHASE == 0) {
	foreach $day (@Days) {
	    &calcAndWrite($day);
	}
    }
    else {
	&getCondsData;

	$y = $startYear;
	$m = $startMonth;
	foreach (0 .. $Range) {
	    if($cMonth == $m) {
		#print "$y $m\n";
		$day = sprintf("%04d%02d%02d", $y, $cMonth, $cDay);
		&calcAndWrite($day);
	    }

	    $m++;
	    if($m > 11) {
		$y++;
		$m -= 12;
	    }
	}
    }
}

sub getCondsData
{
    foreach $cond (@Conds) {
	if($cond eq "Jan") {
	    $cMonth = 1;
	}
	elsif ($cond eq "Feb") {
	    $cMonth = 2;
	}
	elsif ($cond eq "Mar") {
	    $cMonth = 3;
	}
	elsif ($cond eq "Apr") {
	    $cMonth = 4;
	}
	elsif ($cond eq "May") {
	    $cMonth = 5;
	}
	elsif ($cond eq "Jun") {
	    $cMonth = 6;
	}
	elsif ($cond eq "Jul") {
	    $cMonth = 7;
	}
	elsif ($cond eq "Aug") {
	    $cMonth = 8;
	}
	elsif ($cond eq "Sep") {
	    $cMonth = 9;
	}
	elsif ($cond eq "Oct") {
	    $cMonth = 10;
	}
	elsif ($cond eq "Nov") {
	    $cMonth = 11;
	}
	elsif ($cond eq "Dec") {
	    $cMonth = 12;
	}
	else {
	    $cDay = $cond;
	}
    }
}

sub calcAndWrite
{
    local ($day) = @_;

    if($day ne $targetDate) {
      return;
    }
    $writeFlg = 1;

    print ">>>>>day2 '$day'\n"; ##################
    ($vYear, $vMonth, $vDay) = $day =~ m#(\d\d\d\d)(\d\d)(\d\d)#o;
    $sYear = $eYear = $vYear;
    $sMonth = $eMonth = $vMonth;
    $sDay = $eDay = $vDay;
    ($sHour, $sMin) = split(/:/, $sTime);
    ($eHour, $eMin) = split(/:/, $eTime);

    $sYear -= 1900;
    $sMonth--;
    $eYear -= 1900;
    $eMonth--;

    #print ">>>>>>>month $sMonth\n";
    $stime = timelocal(0, $sMin, $sHour, $sDay, $sMonth, $sYear);
    $stime -= 9 * 60 * 60;
    $alarmTime = $stime - $aTime;
    $etime = timelocal(0, $eMin, $eHour, $eDay, $eMonth, $eYear);
    $etime -= 9 * 60 * 60;
    
    ($sSec,$sMin,$sHour,$sDay,$sMonth,$sYear,$swday,$syday,$sIsdst)
	= localtime($stime);
    ($eSec,$eMin,$eHour,$eDay,$eMonth,$eYear,$ewday,$eyday,$eIsdst)
	= localtime($etime);
    ($aSec,$aMin,$aHour,$aDay,$aMonth,$aYear,$awday,$ayday,$aIsdst)
	= localtime($alarmTime);

    $sYear += 1900;
    $sMonth++;
    $eYear += 1900;
    $eMonth++;
    $aYear += 1900;
    $aMonth++;
    
    $DTSTART = sprintf("DTSTART:%04d%02d%02dT%02d%02d00Z\r\n"
		       , $sYear
		       , $sMonth
		       , $sDay
		       , $sHour
		       , $sMin);
    
    $DTEND = sprintf("DTEND:%04d%02d%02dT%02d%02d00Z\r\n"
		     , $eYear
		     , $eMonth
		     , $eDay
		     , $eHour
		     , $eMin);

    if($aTime > 0) {
	$AALARM = sprintf("AALARM:%04d%02d%02dT%02d%02d00Z\r\n"
			  , $aYear
			  , $aMonth
			  , $aDay
			  , $aHour
			  , $aMin);
    }
    else {
	$AALARM = "AALARM:\r\n";
    }

    &writeVcal;
}

sub header
{
    print VCAL "BEGIN:VCALENDAR\r\n";
    print VCAL "VERSION:1.0\r\n";
}

sub footer
{
    print VCAL "END:VCALENDAR\r\n";
}
