/*
 * SpinSpiral.java
 * TAKEchi Masashi
 * $Id: SpinSpiral.java,v 1.6 2002/05/21 13:17:49 take Exp $
 */
package takeBot;
import robocode.*;
import java.awt.Color;

/**
 * @author TAKEchi Masashi
 * @version $Revision: 1.6 $
 */
public class SpinSpiral extends AdvancedRobot
{
    private Enemy target;
    private final double PI = Math.PI;
    private double firePower;
    private final double atackAngle = Math.PI / 3.0;
    private final double atackAngle2 = Math.PI / 2.0;
    private boolean isRight = false;
    private boolean isAhead = true;
    private long lastFireTime;
    private long nextFireTime;
    private double tAngle;

    public void run() {
        this.target = new Enemy();
        this.target.setDistance(100000); // $B=i4|CM$OL58B1s(B
        setColors(Color.red, Color.red, Color.yellow);
        
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        turnRadarRightRadians(2.0 * PI);
        while(true) {
            doMovement(); //Move the bot
            doFirePower(); //select the fire power to use
            doScanner(); //Oscillate the scanner over the bot
            doGun();
            fire(firePower);
            execute(); //execute all commands
            //out.println(this.target.getName() + ":" + this.target.getDistance());
            this.nextFireTime = (nextFireTime + lastFireTime - getTime())
                / 2;
            this.lastFireTime = getTime();
        }
    }
    
    void doFirePower() {
        this.firePower = 400 / this.target.getDistance();
        if(this.firePower > 3.0) {
            this.firePower = 3.0;
        }
    }
    
    void doMovement() {
        if(this.target.getDistance() > 200.0) {
            setTurnAndAheadValue(this.atackAngle);
        }
        else {
            setTurnAndAheadValue(this.atackAngle2);
        }
    }
    private void setTurnAndAheadValue(double angle) {
        if(isRight) {
            this.tAngle = normalRelativeAngle(this.target.getBearing() - angle);
            if(tAngle > PI / 2.0 || tAngle < -PI / 2.0) {
                this.isAhead = false;
                setTurnLeftRadians(normalRelativeAngle(PI - tAngle));
            }
            else {
                this.isAhead = true;
                setTurnRightRadians(tAngle);
            }

        }
        else {
            this.tAngle = normalRelativeAngle(-this.target.getBearing()
                                                - angle);
            if(tAngle > PI / 2.0 || tAngle < -PI / 2.0) {
                this.isAhead = false;
                setTurnRightRadians(normalRelativeAngle(PI - tAngle));
            }
            else {
                this.isAhead = true;
                setTurnLeftRadians(tAngle);
            }
        }
        if(this.isAhead) {
            setAhead(100);
        }
        else {
            setBack(100);
        }
    }
    
    void doScanner() {
        double radarOffset;
        if (getTime() - this.target.getCtime() > 4) {
            setTurnRadarLeftRadians(2.0 * PI);
        }
        else {	
            radarOffset = getRadarHeadingRadians() 
                - absbearing(getX(), getY()
                             , this.target.getX(), this.target.getY());
            
            if (radarOffset < 0.0) {
                radarOffset -= PI / 8.0;
            }
            else {
                radarOffset += PI / 8.0; 
            }
            setTurnRadarLeftRadians(normalRelativeAngle(radarOffset));
        }
    }
    
    void doGun() {
        long time = getTime() 
            + (int)(this.target.getDistance() / (20.0 - (3.0 * firePower)));
        /*
        this.bulletAveV = (bulletAveV + this.myBullet.getVelocity()) / 2.0;
        long time = getTime() 
            + (int)(this.target.getDistance() / this.bulletAveV);
        */
        /*
        double gunOffset = getGunHeadingRadians() 
            - absbearing(getX(), getY()
                         , this.target.guessX(time), this.target.guessY(time));
        */
        double hDis = calcDistance(guessMyX(nextFireTime), guessMyY(nextFireTime)
                                   , target.guessX(time), target.guessY(time));
        time = getTime() 
            + (int)(hDis / (20.0 - (3.0 * firePower)));

        double gunOffset = getGunHeadingRadians() 
            - absbearing(guessMyX(nextFireTime), guessMyY(nextFireTime)
                         , this.target.guessX(time), this.target.guessY(time));
        setTurnGunLeftRadians(normalRelativeAngle(gunOffset));
    }

    private double calcDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }
    
    private double guessMyX(long when) {
        double myDirection;
        if(this.isAhead) {
            myDirection = getHeading() * PI / 180.0 + tAngle;
        }
        else {
            myDirection = getHeading() * PI / 180.0 + PI - tAngle;
        }

        return getX() + Math.sin(normalRelativeAngle(myDirection))
            * getVelocity() * when;
    }

    private double guessMyY(long when) {
        double myDirection;
        if(this.isAhead) {
            myDirection = getHeading() * PI / 180.0;
        }
        else {
            myDirection = getHeading() * PI / 180.0 + PI;
        }
        return getY() + Math.cos(
            normalRelativeAngle(myDirection)
            ) * getVelocity() * when;
    }

    
    /**
     * normalRelativeAngle:  returns angle such that -PI < angle <= PI
     */	
    double normalRelativeAngle(double angle) {
        if (angle > -PI && angle <= PI) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -PI) {
            fixedAngle += 2.0 * PI;
        }
        while (fixedAngle > PI) {
            fixedAngle -= 2.0 * PI;
        }
        return fixedAngle;
    }

    /**
     * normalAbsoluteAngle:  returns angle such that PI <= angle < 2.0 * PI
     */	
    public double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 2.0 * PI) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0) {
            fixedAngle += 2.0 * PI;
        }
        while (fixedAngle >= 2.0 * PI) {
            fixedAngle -= 2.0 * PI;
        }
        return fixedAngle;
    }
    
    //returns the distance between two x,y coordinates
    public double getrange( double x1,double y1, double x2,double y2 )
    {
        double xo = x2-x1;
        double yo = y2-y1;
        double h = Math.sqrt( xo*xo + yo*yo );
        return h;	
    }
    
    //gets the absolute bearing between to x,y coordinates
    public double absbearing( double x1,double y1, double x2,double y2 ) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = getrange(x1, y1, x2, y2);
        if(xo > 0.0 && yo > 0.0) {
                return Math.asin(xo / h);
        }
        if(xo > 0.0 && yo < 0.0) {
            return PI - Math.asin(xo / h);
        }
        if(xo < 0.0 && yo < 0.0) {
            return PI + Math.asin(-xo / h);
        }
        if(xo < 0.0 && yo > 0.0) {
            return 2.0 * PI - Math.asin(-xo / h);
        }
        return 0.0;
    }
    
    
    /**
     * onScannedRobot: What to do when you see another robot
     */
    public void onScannedRobot(ScannedRobotEvent e) {
        if ((e.getDistance() < this.target.getDistance())
            || (this.target.getName() == e.getName())) {

            double absbearing_rad = (getHeadingRadians()
                                     + e.getBearingRadians()) % (2*PI);

            this.target.setName(e.getName());
            this.target.setX(getX() 
                             + Math.sin(absbearing_rad) * e.getDistance());
            this.target.setY(getY()
                             + Math.cos(absbearing_rad) * e.getDistance());
            this.target.setBearing(e.getBearingRadians());
            this.target.setHead(e.getHeadingRadians());
            this.target.setCtime(getTime());
            this.target.setSpeed(e.getVelocity());
            this.target.setDistance(e.getDistance());
        }
    }
    public void onHitRobot(HitRobotEvent e) {
        this.target.setName(e.getName());
        this.target.setX(getX());
        this.target.setY(getY());
        this.target.setBearing(e.getBearingRadians());
        this.target.setHead(0.0);
        this.target.setCtime(getTime());
        this.target.setSpeed(0.0);
        this.target.setDistance(0.0);
    }    
    public void onHitWall(HitWallEvent e) {
        if(isRight) {
            isRight = false;
        }
        else {
            isRight = true;
        }
    }
    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.target.getName())
            this.target.setDistance(10000);
    }
    
}

class Enemy {
    private String name;
    private double bearing;
    private double head;
    private long ctime; //game time that the scan was produced
    private double speed;
    private double x,y;
    private double distance;

    public void setName(String name) {
        this.name = name;
    }
    public String getName() {
        return this.name;
    }
    public void setBearing(double bearing) {
        this.bearing = bearing;
    }
    public double getBearing() {
        return this.bearing;
    }
    public void setHead(double head) {
        this.head = head;
    }
    public double setHead() {
        return this.head;
    }
    public void setCtime(long ctime) {
        this.ctime = ctime;
    }
    public long getCtime() {
        return this.ctime;
    }
    public void setSpeed(double speed) {
        this.speed = speed;
    }
    public double getSpeed() {
        return this.speed;
    }
    public void setX(double x) {
        this.x = x;
    }
    public double getX() {
        return this.x;
    }
    public void setY(double y) {
        this.y = y;
    }
    public double getY() {
        return this.y;
    }
    public void setDistance(double distance) {
        this.distance = distance;
    }
    public double getDistance() {
        return this.distance;
    }
    public double guessX(long when)
    {
        long diff = when - this.ctime;
        return this.x + Math.sin(this.head) * this.speed * diff;
    }
    public double guessY(long when)
    {
        long diff = when - this.ctime;
        return this.y + Math.cos(this.head) * this.speed * diff;
    }
    
}
