/*
 * TAKEchi Masashi
 * $Id: Coordinate.java,v 1.1 2002/06/05 14:06:33 take Exp $
 */
package takeBot;
import robocode.*;
import java.util.*;

/**
 * Coordinate - a class by Simon Parker
 */
public class Coordinate {
    private final double EQUALITY_THRESHOLD = 2.0;
    public double x;
    public double y;
    
    public Coordinate()
    {
        set(0, 0);
    }
    
    
    public Coordinate(double posX, double posY)
    {
        set(posX, posY);
    }
    
    public boolean isEqualTo(Coordinate coordinate)
    {
        return
            (
                (Math.abs(x-coordinate.x) < EQUALITY_THRESHOLD) &&
                (Math.abs(y-coordinate.y) < EQUALITY_THRESHOLD)
		);
    }
    
    public void set(double posX, double posY)
    {
        x = posX;
        y = posY;
    }
    
    public void set(Coordinate coordinate)
    {
        set(coordinate.x, coordinate.y);
    }
    
    public Coordinate minus(Coordinate coordinate)
    {
        return new Coordinate(x - coordinate.x, y - coordinate.y);
    }
    
    public double length()
    {
        return Math.sqrt(x*x+y*y);
    }
    
    public double distanceFrom(Coordinate coordinate)
    {
        return minus(coordinate).length();
    }
}

